/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import net.sf.retrotranslator.android.impl.LazyValue;
import net.sf.retrotranslator.android.impl.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardTypeImpl
implements WildcardType {
    private static final Type[] DEFAULT_UPPER_BOUND = new Type[]{Object.class};
    private static final Type[] DEFAULT_LOWER_BOUND = new Type[0];
    private boolean isUpperBounds;
    private LazyValue<TypeDescriptor, Type> bound;

    public WildcardTypeImpl(boolean isUpperBounds, LazyValue<TypeDescriptor, Type> bound) {
        this.isUpperBounds = isUpperBounds;
        this.bound = bound;
    }

    @Override
    public Type[] getUpperBounds() {
        Type[] typeArray;
        if (this.isUpperBounds && this.bound != null) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = this.bound.get();
        } else {
            typeArray = DEFAULT_UPPER_BOUND;
        }
        return typeArray;
    }

    @Override
    public Type[] getLowerBounds() {
        Type[] typeArray;
        if (this.isUpperBounds || this.bound == null) {
            typeArray = DEFAULT_LOWER_BOUND;
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = this.bound.get();
        }
        return typeArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getUpperBounds()) ^ Arrays.hashCode(this.getLowerBounds());
    }

    public boolean equals(Object obj) {
        if (obj instanceof WildcardType) {
            if (obj == this) {
                return true;
            }
            WildcardType type = (WildcardType)obj;
            return Arrays.equals(this.getUpperBounds(), type.getUpperBounds()) && Arrays.equals(this.getLowerBounds(), type.getLowerBounds());
        }
        return false;
    }

    public String toString() {
        if (this.bound == null) {
            return "?";
        }
        Type bound = this.bound.get();
        return (this.isUpperBounds ? "? extends " : "? super ") + (bound instanceof Class ? ((Class)bound).getName() : bound.toString());
    }
}

