/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.main.java.lang;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sf.retrotranslator.android.impl.ClassDescriptor;
import net.sf.retrotranslator.android.impl.RuntimeTools;

public class _Package {
    public static Annotation getAnnotation(Package aPackage, Class annotationType) {
        return _Package.getPackageInfo(aPackage).getAnnotation(annotationType);
    }

    public static Annotation[] getAnnotations(Package aPackage) {
        return _Package.getPackageInfo(aPackage).getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Package aPackage) {
        return _Package.getPackageInfo(aPackage).getDeclaredAnnotations();
    }

    public static boolean isAnnotationPresent(Package aPackage, Class annotationType) {
        return _Package.getPackageInfo(aPackage).isAnnotationPresent(annotationType);
    }

    private static ClassDescriptor getPackageInfo(Package aPackage) {
        ClassDescriptor packageInfo = _Package.createPackageInfo(_Package.class, aPackage);
        return packageInfo != null ? packageInfo : _Package.getPrivilegedInfo(aPackage);
    }

    private static ClassDescriptor createPackageInfo(Class loader, Package aPackage) {
        byte[] bytecode = _Package.getBytecode(loader, aPackage);
        if (bytecode != null) {
            return new ClassDescriptor(loader, bytecode);
        }
        for (String simpleName : new String[]{"package$info", "package-info"}) {
            Class infoClass = _Package.getClass(loader, aPackage, simpleName);
            if (infoClass == null) continue;
            return ClassDescriptor.getInstance(infoClass);
        }
        return null;
    }

    private static Class getClass(Class loader, Package aPackage, String simpleName) {
        try {
            return Class.forName(aPackage.getName() + "." + simpleName, true, loader.getClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static byte[] getBytecode(Class loader, Package aPackage) {
        String resourceName = "/" + aPackage.getName().replace('.', '/') + "/package-info.class";
        return RuntimeTools.readResourceToByteArray(loader, resourceName);
    }

    private static ClassDescriptor getPrivilegedInfo(final Package aPackage) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassDescriptor>(){

            @Override
            public ClassDescriptor run() {
                return _Package.getContextInfo(aPackage);
            }
        });
    }

    private static ClassDescriptor getContextInfo(Package aPackage) {
        try {
            for (Class contextClass : new ExecutionContext().getClassContext()) {
                try {
                    ClassDescriptor packageInfo = _Package.createPackageInfo(contextClass, aPackage);
                    if (packageInfo == null) continue;
                    return packageInfo;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ClassDescriptor.getInstance(_Package.class);
    }

    private static class ExecutionContext
    extends SecurityManager {
        private ExecutionContext() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

