/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.main.java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.retrotranslator.android.impl.MethodDescriptor;
import net.sf.retrotranslator.android.impl.RuntimeTools;

public class _Constructor {
    public static Annotation getAnnotation(Constructor constructor, Class annotationType) {
        return MethodDescriptor.getInstance(constructor).getAnnotation(annotationType);
    }

    public static Annotation[] getAnnotations(Constructor constructor) {
        return MethodDescriptor.getInstance(constructor).getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Constructor constructor) {
        return MethodDescriptor.getInstance(constructor).getDeclaredAnnotations();
    }

    public static Type[] getGenericExceptionTypes(Constructor constructor) {
        return RuntimeTools.getTypes(constructor.getExceptionTypes(), MethodDescriptor.getInstance(constructor).getGenericExceptionTypes());
    }

    public static Type[] getGenericParameterTypes(Constructor constructor) {
        return RuntimeTools.getTypes(constructor.getParameterTypes(), MethodDescriptor.getInstance(constructor).getGenericParameterTypes());
    }

    public static Annotation[][] getParameterAnnotations(Constructor constructor) {
        return MethodDescriptor.getInstance(constructor).getParameterAnnotations();
    }

    public static TypeVariable[] getTypeParameters(Constructor constructor) {
        return MethodDescriptor.getInstance(constructor).getTypeParameters();
    }

    public static boolean isAnnotationPresent(Constructor constructor, Class annotationType) {
        return MethodDescriptor.getInstance(constructor).isAnnotationPresent(annotationType);
    }

    public static boolean isSynthetic(Constructor constructor) {
        return MethodDescriptor.getInstance(constructor).isAccess(4096);
    }

    public static boolean isVarArgs(Constructor constructor) {
        return MethodDescriptor.getInstance(constructor).isAccess(128);
    }

    public static String toGenericString(Constructor constructor) {
        Type[] typeParameters;
        StringBuilder builder = new StringBuilder();
        if (constructor.getModifiers() != 0) {
            builder.append(Modifier.toString(constructor.getModifiers())).append(' ');
        }
        if ((typeParameters = _Constructor.getTypeParameters(constructor)).length > 0) {
            RuntimeTools.append(builder.append('<'), typeParameters).append("> ");
        }
        builder.append(RuntimeTools.getString(constructor.getDeclaringClass()));
        RuntimeTools.append(builder.append('('), _Constructor.getGenericParameterTypes(constructor)).append(')');
        Type[] exceptionTypes = _Constructor.getGenericExceptionTypes(constructor);
        if (exceptionTypes.length > 0) {
            RuntimeTools.append(builder.append(" throws "), exceptionTypes);
        }
        return builder.toString();
    }
}

