/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.main.java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.retrotranslator.android.impl.MethodDescriptor;
import net.sf.retrotranslator.android.impl.RuntimeTools;

public class _Method {
    public static Annotation getAnnotation(Method method, Class annotationType) {
        return MethodDescriptor.getInstance(method).getAnnotation(annotationType);
    }

    public static Annotation[] getAnnotations(Method method) {
        return MethodDescriptor.getInstance(method).getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Method method) {
        return MethodDescriptor.getInstance(method).getDeclaredAnnotations();
    }

    public static Object getDefaultValue(Method method) {
        return MethodDescriptor.getInstance(method).getDefaultValue();
    }

    public static Type[] getGenericExceptionTypes(Method method) {
        return RuntimeTools.getTypes(method.getExceptionTypes(), MethodDescriptor.getInstance(method).getGenericExceptionTypes());
    }

    public static Type[] getGenericParameterTypes(Method method) {
        return RuntimeTools.getTypes(method.getParameterTypes(), MethodDescriptor.getInstance(method).getGenericParameterTypes());
    }

    public static Type getGenericReturnType(Method method) {
        return RuntimeTools.getType(method.getReturnType(), MethodDescriptor.getInstance(method).getGenericReturnType());
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        return MethodDescriptor.getInstance(method).getParameterAnnotations();
    }

    public static TypeVariable[] getTypeParameters(Method method) {
        return MethodDescriptor.getInstance(method).getTypeParameters();
    }

    public static boolean isAnnotationPresent(Method method, Class annotationType) {
        return MethodDescriptor.getInstance(method).isAnnotationPresent(annotationType);
    }

    public static boolean isBridge(Method method) {
        return MethodDescriptor.getInstance(method).isAccess(64);
    }

    public static boolean isSynthetic(Method method) {
        return MethodDescriptor.getInstance(method).isAccess(4096);
    }

    public static boolean isVarArgs(Method method) {
        return MethodDescriptor.getInstance(method).isAccess(128);
    }

    public static String toGenericString(Method method) {
        Type[] typeParameters;
        StringBuilder builder = new StringBuilder();
        if (method.getModifiers() != 0) {
            builder.append(Modifier.toString(method.getModifiers())).append(' ');
        }
        if ((typeParameters = _Method.getTypeParameters(method)).length > 0) {
            RuntimeTools.append(builder.append('<'), typeParameters).append("> ");
        }
        builder.append(RuntimeTools.getString(_Method.getGenericReturnType(method))).append(' ');
        builder.append(RuntimeTools.getString(method.getDeclaringClass())).append('.').append(method.getName());
        RuntimeTools.append(builder.append('('), _Method.getGenericParameterTypes(method)).append(')');
        Type[] exceptionTypes = _Method.getGenericExceptionTypes(method);
        if (exceptionTypes.length > 0) {
            RuntimeTools.append(builder.append(" throws "), exceptionTypes);
        }
        return builder.toString();
    }
}

