/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.runtime.impl.BytecodeTransformer;
import net.sf.retrotranslator.runtime.impl.FieldDescriptor;
import net.sf.retrotranslator.runtime.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.runtime.impl.LazyList;
import net.sf.retrotranslator.runtime.impl.LazyValue;
import net.sf.retrotranslator.runtime.impl.MethodDescriptor;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime.java.lang.annotation.Inherited_;
import net.sf.retrotranslator.runtime.java.lang.reflect.GenericDeclaration_;
import net.sf.retrotranslator.runtime.java.lang.reflect.MalformedParameterizedTypeException_;
import net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;
import net.sf.retrotranslator.runtime.java.lang.reflect.Type_;

public class ClassDescriptor
extends GenericDeclarationDescriptor {
    private static SoftReference cache;
    private static Properties signatures;
    private static BytecodeTransformer bytecodeTransformer;
    private String name;
    private Class target;
    private String enclosingClass;
    private String enclosingMethod;
    private LazyList genericInterfaces;
    private LazyValue genericSuperclass;
    private Map fieldDescriptors = new HashMap();
    private Map methodDescriptors = new HashMap();
    static /* synthetic */ Class class$net$sf$retrotranslator$runtime$impl$ClassDescriptor;
    static /* synthetic */ Class class$net$sf$retrotranslator$runtime$java$lang$annotation$Inherited_;

    private static Properties getSignatures() {
        try {
            InputStream stream;
            Properties properties = new Properties();
            Class<?> clazz = class$net$sf$retrotranslator$runtime$impl$ClassDescriptor;
            if (clazz == null) {
                clazz = class$net$sf$retrotranslator$runtime$impl$ClassDescriptor = new ClassDescriptor[0].getClass().getComponentType();
            }
            if ((stream = clazz.getResourceAsStream("signatures.properties")) != null) {
                properties.load(stream);
                stream.close();
            }
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassDescriptor(Class target, byte[] bytecode) {
        this.target = target;
        if (bytecode != null) {
            if (bytecodeTransformer != null) {
                bytecode = bytecodeTransformer.transform(bytecode, 0, bytecode.length);
            }
            new ClassReader(bytecode).accept(this, true);
        }
    }

    public static void setBytecodeTransformer(BytecodeTransformer transformer) {
        bytecodeTransformer = transformer;
    }

    public static ClassDescriptor getInstance(Class target) {
        Map map = ClassDescriptor.getMap();
        ClassDescriptor descriptor = (ClassDescriptor)map.get(target);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = new ClassDescriptor(target, RuntimeTools.getBytecode(target));
        map.put(target, descriptor);
        return descriptor;
    }

    private static synchronized Map getMap() {
        Hashtable map;
        Hashtable hashtable = map = cache == null ? null : (Hashtable)cache.get();
        if (map == null) {
            map = new Hashtable();
            cache = new SoftReference(map);
        }
        return map;
    }

    protected Annotation_[] createAnnotations(Annotation_[] declaredAnnotations) {
        Annotation_ annotation;
        int i$;
        Class superclass = this.target.getSuperclass();
        if (superclass == null) {
            return declaredAnnotations;
        }
        Annotation_[] superAnnotations = ClassDescriptor.getInstance(superclass).getAnnotations();
        if (superAnnotations.length == 0) {
            return declaredAnnotations;
        }
        HashMap result = new HashMap();
        Annotation_[] arr$ = superAnnotations;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            annotation = arr$[i$];
            Class<?> annotationClass = annotation.getClass().getInterfaces()[0];
            Class<?> clazz = class$net$sf$retrotranslator$runtime$java$lang$annotation$Inherited_;
            if (clazz == null) {
                clazz = new Inherited_[0].getClass().getComponentType();
            }
            if (!_Class.isAnnotationPresent(annotationClass, clazz)) continue;
            result.put(annotationClass, annotation);
        }
        arr$ = declaredAnnotations;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            annotation = arr$[i$];
            result.put(annotation.getClass().getInterfaces()[0], annotation);
        }
        return result.values().toArray(new Annotation_[result.size()]);
    }

    public String getName() {
        return this.name;
    }

    public ClassDescriptor getClassDescriptor() {
        return this;
    }

    public MethodDescriptor getEnclosingMethodDescriptor() {
        return this.enclosingMethod == null ? null : ClassDescriptor.getInstance(this.getClassByInternalName(this.enclosingClass)).getMethodDescriptor(this.enclosingMethod);
    }

    public boolean isLocalOrAnonymous() {
        return this.enclosingMethod != null;
    }

    public FieldDescriptor getFieldDescriptor(String name) {
        return (FieldDescriptor)this.fieldDescriptors.get(name);
    }

    public Type_[] getGenericInterfaces() {
        return this.genericInterfaces == null ? null : this.genericInterfaces.getClone();
    }

    public Type_ getGenericSuperclass() {
        Object object;
        if (this.genericSuperclass == null) {
            object = null;
        } else {
            object = this.genericSuperclass.get();
            if (!(object instanceof Class)) {
                object = object;
                if (!(object instanceof Class)) {
                    object = (Type_)object;
                }
            }
        }
        return object;
    }

    public MethodDescriptor getMethodDescriptor(String key) {
        return (MethodDescriptor)this.methodDescriptors.get(key);
    }

    public Collection getMethodDescriptors() {
        return this.methodDescriptors.values();
    }

    public Collection getFieldDescriptors() {
        return this.fieldDescriptors.values();
    }

    public Class getTarget() {
        return this.target;
    }

    protected TypeVariable_ findTypeVariable(String name) {
        TypeVariable_ variable = this.getTypeVariable(name);
        if (variable != null) {
            return variable;
        }
        MethodDescriptor methodDescriptor = this.getEnclosingMethodDescriptor();
        if (methodDescriptor != null) {
            return methodDescriptor.findTypeVariable(name);
        }
        Class<?> declaringClass = this.target.getDeclaringClass();
        if (declaringClass != null) {
            return ClassDescriptor.getInstance(declaringClass).findTypeVariable(name);
        }
        throw new MalformedParameterizedTypeException_();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.name = name;
        if (signature == null) {
            signature = signatures.getProperty(name);
        }
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (name != null) {
            this.enclosingClass = owner;
            this.enclosingMethod = name + desc;
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.equals(this.name)) {
            this.access |= access;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(this, access, name, desc, signature);
        this.fieldDescriptors.put(name, fieldDescriptor);
        return fieldDescriptor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(this, access, name, desc, signature);
        this.methodDescriptors.put(name + desc, methodDescriptor);
        return methodDescriptor;
    }

    public SignatureVisitor visitSuperclass() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (!this.isAccess(512)) {
            this.genericSuperclass = this.getLazyType(descriptor);
        }
        return descriptor;
    }

    public SignatureVisitor visitInterface() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericInterfaces == null) {
            this.genericInterfaces = this.getLazyList();
        }
        this.genericInterfaces.add(descriptor);
        return descriptor;
    }

    public /* synthetic */ GenericDeclaration_ getTarget() {
        return this.getTarget();
    }

    static {
        signatures = ClassDescriptor.getSignatures();
    }
}

