/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.MissingResourceException;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.java.lang.reflect.Type_;

public class RuntimeTools {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_NAME = "<clinit>";
    private static final String CLASS_EXTENSION = ".class";

    public static Class getBaseClass(char type) {
        return RuntimeTools.getBaseClass(Type.getType(new String(new char[]{type})));
    }

    public static Class getBaseClass(Type type) {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        return null;
    }

    public static String getConstructorDescriptor(Constructor c) {
        Class<?>[] parameters = c.getParameterTypes();
        StringBuffer buf = new StringBuffer("(");
        Class<?>[] arr$ = parameters;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> parameter = arr$[i$];
            buf.append(Type.getDescriptor(parameter));
        }
        return buf.append(")V").toString();
    }

    public static Object cloneNonEmptyArray(Object value) {
        if (!value.getClass().isArray() || Array.getLength(value) == 0) {
            return value;
        }
        if (value instanceof Object[]) {
            return ((Object[])value).clone();
        }
        if (value instanceof boolean[]) {
            return ((boolean[])value).clone();
        }
        if (value instanceof byte[]) {
            return ((byte[])value).clone();
        }
        if (value instanceof char[]) {
            return ((char[])value).clone();
        }
        if (value instanceof double[]) {
            return ((double[])value).clone();
        }
        if (value instanceof float[]) {
            return ((float[])value).clone();
        }
        if (value instanceof int[]) {
            return ((int[])value).clone();
        }
        if (value instanceof long[]) {
            return ((long[])value).clone();
        }
        if (value instanceof short[]) {
            return ((short[])value).clone();
        }
        throw new IllegalStateException();
    }

    public static String getString(Type_ type) {
        if (!(type instanceof Class)) {
            return type.toString();
        }
        Class<?> aClass = (Class<?>)((Object)type);
        int dimensionCount = 0;
        while (aClass.isArray()) {
            aClass = aClass.getComponentType();
            ++dimensionCount;
        }
        if (dimensionCount == 0) {
            return aClass.getName();
        }
        StringBuffer builder = new StringBuffer();
        builder.append(aClass.getName());
        while (dimensionCount > 0) {
            builder.append("[]");
            --dimensionCount;
        }
        return builder.toString();
    }

    public static StringBuffer append(StringBuffer builder, Type_[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(RuntimeTools.getString(types[i]));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readResourceToByteArray(Class loader, String resourceName) throws MissingResourceException {
        byte[] byArray;
        InputStream inputStream = loader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            return null;
        }
        try {
            int count;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((count = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return byArray;
    }

    public static byte[] getBytecode(Class target) {
        if (target.isPrimitive() || target.isArray()) {
            return null;
        }
        String targetName = target.getName();
        int index = targetName.lastIndexOf(46);
        String simpleName = index < 0 ? targetName : targetName.substring(index + 1);
        return RuntimeTools.readResourceToByteArray(target, simpleName + CLASS_EXTENSION);
    }
}

