/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.retrotranslator.runtime.impl.Advanced;

public class _BigDecimal {
    public static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    public static final BigDecimal ONE = BigDecimal.valueOf(1L);
    public static final BigDecimal TEN = BigDecimal.valueOf(10L);

    public static BigInteger convertConstructorArguments(int value) {
        return BigInteger.valueOf(value);
    }

    public static BigInteger convertConstructorArguments(long value) {
        return BigInteger.valueOf(value);
    }

    public static String convertConstructorArguments(char[] in, int offset, int len) {
        return new String(in, offset, len);
    }

    public static String convertConstructorArguments(char[] in) {
        return new String(in);
    }

    public static BigDecimal[] divideAndRemainder(BigDecimal dividend, BigDecimal divisor) {
        BigDecimal quotient = _BigDecimal.divideToIntegralValue(dividend, divisor);
        BigDecimal[] result = new BigDecimal[]{quotient, dividend.subtract(quotient.multiply(divisor))};
        return result;
    }

    public static BigDecimal divideToIntegralValue(BigDecimal dividend, BigDecimal divisor) {
        BigDecimal quotient = dividend.divide(divisor, 0, 1);
        if (dividend.scale() > divisor.scale()) {
            quotient = quotient.setScale(dividend.scale() - divisor.scale());
        }
        return quotient;
    }

    public static BigDecimal pow(BigDecimal bigDecimal, int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        BigDecimal result = ONE;
        while (n-- > 0) {
            result = result.multiply(bigDecimal);
        }
        return result;
    }

    public static BigDecimal remainder(BigDecimal dividend, BigDecimal divisor) {
        return dividend.subtract(_BigDecimal.divideToIntegralValue(dividend, divisor).multiply(divisor));
    }

    @Advanced(value={"BigDecimal.setScale"})
    public static BigDecimal setScale(BigDecimal bigDecimal, int newScale, int roundingMode) {
        if (newScale >= 0) {
            return bigDecimal.setScale(newScale, roundingMode);
        }
        return bigDecimal.movePointRight(newScale).setScale(0, roundingMode).movePointLeft(newScale);
    }

    public static String toPlainString(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static BigDecimal valueOf(double val) {
        return new BigDecimal(Double.toString(val));
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }
}

