/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.net;

import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import net.sf.retrotranslator.runtime.impl.Advanced;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.net._URLConnection;

public class _HttpURLConnection {
    @Advanced(value={"URLConnection.getConnectTimeout"})
    public static int getConnectTimeout(HttpURLConnection httpURLConnection) {
        return _URLConnection.getConnectTimeout(httpURLConnection);
    }

    @Advanced(value={"URLConnection.getReadTimeout"})
    public static int getReadTimeout(HttpURLConnection httpURLConnection) {
        return _URLConnection.getReadTimeout(httpURLConnection);
    }

    @Advanced(value={"HttpURLConnection.setChunkedStreamingMode"})
    public static void setChunkedStreamingMode(HttpURLConnection httpURLConnection, int chunklen) {
        try {
            RuntimeTools.invokeMethod(httpURLConnection, "setChunkedStreamingMode", new Class[]{Integer.TYPE}, new Object[]{_Integer.valueOf(chunklen)});
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            throw RuntimeTools.unwrap(e);
        }
    }

    @Advanced(value={"URLConnection.setConnectTimeout"})
    public static void setConnectTimeout(HttpURLConnection httpURLConnection, int timeout) {
        _URLConnection.setConnectTimeout(httpURLConnection, timeout);
    }

    @Advanced(value={"HttpURLConnection.setFixedLengthStreamingMode"})
    public static void setFixedLengthStreamingMode(HttpURLConnection httpURLConnection, int contentLength) {
        try {
            RuntimeTools.invokeMethod(httpURLConnection, "setFixedLengthStreamingMode", new Class[]{Integer.TYPE}, new Object[]{_Integer.valueOf(contentLength)});
        }
        catch (NoSuchMethodException e) {
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(contentLength));
        }
        catch (InvocationTargetException e) {
            throw RuntimeTools.unwrap(e);
        }
    }

    @Advanced(value={"URLConnection.setReadTimeout"})
    public static void setReadTimeout(HttpURLConnection httpURLConnection, int timeout) {
        _URLConnection.setReadTimeout(httpURLConnection, timeout);
    }
}

