/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.Date;
import net.sf.retrotranslator.runtime.impl.Advanced;
import net.sf.retrotranslator.runtime.java.util.TimerTask_;

@Advanced(value={"Timer.All"})
public class Timer_ {
    private static AtomicInteger counter = new AtomicInteger();
    private final ScheduledThreadPoolExecutor executor;
    private final Object finalizer = new Object(){

        protected void finalize() throws Throwable {
            Timer_.this.executor.shutdown();
        }
    };

    public Timer_() {
        this(false);
    }

    public Timer_(boolean isDaemon) {
        this("Timer-" + counter.getAndIncrement(), isDaemon);
    }

    public Timer_(String name) {
        this(name, false);
    }

    public Timer_(String name, boolean isDaemon) {
        this.executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new TimerThreadFactory(name, isDaemon));
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)new TimerRejectedExecutionHandler());
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
        this.executor.prestartCoreThread();
    }

    public void cancel() {
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.shutdown();
    }

    public int purge() {
        int count = 0;
        BlockingQueue queue = this.executor.getQueue();
        Object[] arr$ = queue.toArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object object = arr$[i$];
            if (!(object instanceof Future) || !((Future)object).isCancelled() || !queue.remove(object)) continue;
            ++count;
        }
        return count;
    }

    public void schedule(TimerTask_ task, Date time) {
        long delay = Timer_.checkDelay(time);
        task.command.runOnce(this.executor, delay);
    }

    public void schedule(TimerTask_ task, Date firstTime, long period) {
        Timer_.checkPeriod(period);
        long delay = Timer_.checkDelay(firstTime);
        task.command.runWithFixedDelay(this.executor, delay, period);
    }

    public void scheduleAtFixedRate(TimerTask_ task, Date firstTime, long period) {
        Timer_.checkPeriod(period);
        long delay = Timer_.checkDelay(firstTime);
        task.command.runAtFixedRate(this.executor, delay, period);
    }

    public void schedule(TimerTask_ task, long delay) {
        Timer_.checkDelay(delay);
        task.command.runOnce(this.executor, delay);
    }

    public void schedule(TimerTask_ task, long delay, long period) {
        Timer_.checkDelay(delay);
        Timer_.checkPeriod(period);
        task.command.runWithFixedDelay(this.executor, delay, period);
    }

    public void scheduleAtFixedRate(TimerTask_ task, long delay, long period) {
        Timer_.checkDelay(delay);
        Timer_.checkPeriod(period);
        task.command.runAtFixedRate(this.executor, delay, period);
    }

    private static long checkDelay(Date date) {
        long time = date.getTime();
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        return time - System.currentTimeMillis();
    }

    private static void checkDelay(long delay) {
        if (delay < 0L || delay + System.currentTimeMillis() < 0L) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkPeriod(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
    }

    private static class TimerRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private TimerRejectedExecutionHandler() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new IllegalStateException();
        }
    }

    private static class TimerThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;

        public TimerThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.name);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

