/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime13.v15.java.util;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public abstract class TimerTask_
implements Runnable {
    final TimerCommand command = new TimerCommand();

    protected TimerTask_() {
    }

    public abstract void run();

    public boolean cancel() {
        return this.command.cancel();
    }

    public long scheduledExecutionTime() {
        return this.command.getExecutionTime();
    }

    class TimerCommand
    implements Runnable {
        private boolean periodic;
        private boolean cancelled;
        private long executionTime;
        private ScheduledFuture future;
        private ScheduledThreadPoolExecutor executor;

        TimerCommand() {
        }

        public void run() {
            try {
                this.saveExecutionTime();
                TimerTask_.this.run();
            }
            catch (ThreadDeath e) {
                this.shutdownExecutor();
                throw e;
            }
        }

        private synchronized void saveExecutionTime() {
            this.executionTime = System.currentTimeMillis() + this.future.getDelay(TimeUnit.MILLISECONDS);
        }

        private synchronized void shutdownExecutor() {
            this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor.shutdown();
        }

        synchronized long getExecutionTime() {
            return this.executionTime;
        }

        synchronized boolean cancel() {
            this.cancelled = true;
            if (this.future == null) {
                return false;
            }
            if (!this.periodic && this.future.getDelay(TimeUnit.MILLISECONDS) <= 0L) {
                this.future.cancel(false);
                return false;
            }
            return this.future.cancel(false);
        }

        synchronized void runOnce(ScheduledThreadPoolExecutor executor, long delay) {
            this.check();
            this.init(false, executor, executor.schedule((Runnable)this, delay, TimeUnit.MILLISECONDS));
        }

        synchronized void runWithFixedDelay(ScheduledThreadPoolExecutor executor, long delay, long period) {
            this.check();
            this.init(true, executor, executor.scheduleWithFixedDelay((Runnable)this, delay, period, TimeUnit.MILLISECONDS));
        }

        synchronized void runAtFixedRate(ScheduledThreadPoolExecutor executor, long delay, long period) {
            this.check();
            this.init(true, executor, executor.scheduleAtFixedRate((Runnable)this, delay, period, TimeUnit.MILLISECONDS));
        }

        private void check() {
            if (this.cancelled || this.executor != null) {
                throw new IllegalStateException();
            }
        }

        private void init(boolean periodic, ScheduledThreadPoolExecutor executor, ScheduledFuture future) {
            this.periodic = periodic;
            this.executor = executor;
            this.future = future;
        }
    }
}

