/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.io;

import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.robocode.host.io.RobotFileSystemManager;

public class RobotFileOutputStream
extends FileOutputStream {
    private RobotFileSystemManager fileSystemManager;

    public RobotFileOutputStream(String filename, boolean append, RobotFileSystemManager fileSystemManager) throws IOException {
        super(filename, append);
        this.fileSystemManager = fileSystemManager;
        fileSystemManager.addStream(this);
    }

    @Override
    public final void close() throws IOException {
        this.fileSystemManager.removeStream(this);
        super.close();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        try {
            this.fileSystemManager.checkQuota(b.length);
            super.write(b);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.fileSystemManager.checkQuota(len);
            super.write(b, off, len);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public final void write(int b) throws IOException {
        try {
            this.fileSystemManager.checkQuota(1L);
            super.write(b);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }
}

