/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.proxies.AdvancedRobotProxy;
import net.sf.robocode.host.serialization.RobocodeObjectInputStream;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.peer.TeamMessage;
import net.sf.robocode.repository.IRobotItem;
import robocode.Event;
import robocode.MessageEvent;
import robocode.robotinterfaces.peer.ITeamRobotPeer;

public class TeamRobotProxy
extends AdvancedRobotProxy
implements ITeamRobotPeer {
    private static final int MAX_MESSAGE_SIZE = 32768;
    private final ByteArrayOutputStream byteStreamWriter = new ByteArrayOutputStream(32768);

    public TeamRobotProxy(IRobotItem specification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        super(specification, hostManager, peer, statics);
    }

    public String[] getTeammates() {
        this.getCall();
        return this.statics.getTeammates();
    }

    public boolean isTeammate(String name) {
        this.getCall();
        if (name != null) {
            if (name.equals(this.statics.getName())) {
                return true;
            }
            String[] teammates = this.statics.getTeammates();
            if (teammates != null) {
                for (String mate : teammates) {
                    if (!mate.equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void broadcastMessage(Serializable message) throws IOException {
        this.sendMessage(null, message);
    }

    public void sendMessage(String name, Serializable message) throws IOException {
        this.setCall();
        try {
            if (!this.statics.isTeamRobot()) {
                throw new IOException("You are not on a team.");
            }
            this.byteStreamWriter.reset();
            ObjectOutputStream objectStreamWriter = new ObjectOutputStream(this.byteStreamWriter);
            objectStreamWriter.writeObject(message);
            objectStreamWriter.flush();
            this.byteStreamWriter.flush();
            byte[] bytes = this.byteStreamWriter.toByteArray();
            objectStreamWriter.reset();
            if (bytes.length > 32768) {
                throw new IOException("Message too big. " + bytes.length + ">" + 32768);
            }
            this.commands.getTeamMessages().add(new TeamMessage(this.getName(), name, bytes));
        }
        catch (IOException e) {
            this.out.printStackTrace(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void loadTeamMessages(List<TeamMessage> teamMessages) {
        if (teamMessages == null) {
            return;
        }
        for (TeamMessage teamMessage : teamMessages) {
            try {
                ByteArrayInputStream byteStreamReader = new ByteArrayInputStream(teamMessage.message);
                byteStreamReader.reset();
                ObjectInputStream objectStreamReader = null;
                try {
                    objectStreamReader = new RobocodeObjectInputStream(byteStreamReader, (ClassLoader)this.robotClassLoader);
                    Serializable message = (Serializable)objectStreamReader.readObject();
                    MessageEvent event = new MessageEvent(teamMessage.sender, message);
                    this.eventManager.add((Event)event);
                }
                finally {
                    if (objectStreamReader == null) continue;
                    objectStreamReader.close();
                }
            }
            catch (IOException e) {
                this.out.printStackTrace(e);
            }
            catch (ClassNotFoundException e) {
                this.out.printStackTrace(e);
            }
        }
    }

    public List<MessageEvent> getMessageEvents() {
        this.getCall();
        return this.eventManager.getMessageEvents();
    }
}

