/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.root.BaseRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;

class Repository
implements IRepository {
    private Map<String, IRepositoryRoot> roots = new ConcurrentHashMap<String, IRepositoryRoot>();
    private Map<String, IRepositoryItem> repositoryItems = new ConcurrentHashMap<String, IRepositoryItem>();
    private Map<String, IRepositoryItem> removedItems = new ConcurrentHashMap<String, IRepositoryItem>();

    Repository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream out) {
        HashSet<IRepositoryItem> uniqueItems = new HashSet<IRepositoryItem>();
        HashSet<IRepositoryRoot> uniqueRoots = new HashSet<IRepositoryRoot>();
        for (IRepositoryItem repositoryItem : this.repositoryItems.values()) {
            uniqueItems.add(repositoryItem);
        }
        for (IRepositoryRoot root : this.roots.values()) {
            uniqueRoots.add(root);
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(out);
            oos.writeObject(uniqueRoots);
            oos.writeObject(uniqueItems);
        }
        catch (IOException e) {
            try {
                Logger.logError((String)"Can't save robot database", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream(oos);
                throw throwable;
            }
            FileUtil.cleanupStream((Object)oos);
        }
        FileUtil.cleanupStream((Object)oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void load(InputStream in) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(in);
            Set uniqueRoots = (Set)ois.readObject();
            Set uniqueItems = (Set)ois.readObject();
            for (IRepositoryRoot root : uniqueRoots) {
                ((BaseRoot)root).setRepository(this);
                String key = root.getURL().toString();
                key = URLDecoder.decode(key, "UTF-8");
                this.roots.put(key, root);
            }
            for (IRepositoryItem repositoryItem : uniqueItems) {
                this.addOrUpdateItem(repositoryItem);
            }
        }
        catch (IOException e) {
            Logger.logError((String)("Can't load robot database: " + e.getMessage()));
            FileUtil.cleanupStream((Object)ois);
        }
        catch (ClassNotFoundException e2) {
            Logger.logError((String)("Can't load robot database: " + e2.getMessage()));
            {
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(ois);
                    throw throwable;
                }
            }
            FileUtil.cleanupStream((Object)ois);
        }
        FileUtil.cleanupStream((Object)ois);
    }

    @Override
    public void addOrUpdateItem(IRepositoryItem repositoryItem) {
        Set<String> friendlyUrls = repositoryItem.getFriendlyURLs();
        if (friendlyUrls != null) {
            for (String friendly : friendlyUrls) {
                IRepositoryItem existingItem;
                if (friendly == null || (existingItem = this.repositoryItems.get(friendly)) != null && repositoryItem.compareTo(existingItem) <= 0) continue;
                this.repositoryItems.put(friendly, repositoryItem);
            }
        }
    }

    @Override
    public IRepositoryItem getItem(String friendlyUrl) {
        IRepositoryItem repositoryItem = this.repositoryItems.get(friendlyUrl);
        if (repositoryItem == null) {
            repositoryItem = this.removedItems.get(friendlyUrl);
        }
        return repositoryItem;
    }

    @Override
    public Map<String, IRepositoryItem> getItems() {
        return Collections.unmodifiableMap(this.repositoryItems);
    }

    @Override
    public Map<String, IRepositoryRoot> getRoots() {
        return Collections.unmodifiableMap(this.roots);
    }

    @Override
    public void removeRoot(String friendlyUrl) {
        this.roots.remove(friendlyUrl);
    }

    @Override
    public void removeItemsFromRoot(IRepositoryRoot root) {
        ArrayList<Map.Entry<String, IRepositoryItem>> itemsToRemove = new ArrayList<Map.Entry<String, IRepositoryItem>>();
        for (Map.Entry<String, IRepositoryItem> entry : this.repositoryItems.entrySet()) {
            if (!entry.getValue().getRoot().equals(root)) continue;
            itemsToRemove.add(entry);
        }
        for (Map.Entry<String, IRepositoryItem> entry : itemsToRemove) {
            String key = entry.getKey();
            this.removedItems.put(key, entry.getValue());
            this.repositoryItems.remove(key);
        }
    }

    public void setRoots(Map<String, IRepositoryRoot> newRoots) {
        for (IRepositoryRoot root : this.roots.values()) {
            if (newRoots.containsKey(root.getURL().toString())) continue;
            this.removeItemsFromRoot(root);
        }
        this.roots = newRoots;
        this.removedItems.clear();
    }
}

