/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.repository.Repository;
import net.sf.robocode.repository.RobotProperties;
import net.sf.robocode.repository.TeamProperties;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.RepositoryItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.TeamItem;
import net.sf.robocode.repository.packager.JarCreator;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.repository.root.handlers.RootHandler;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IWindowManager;
import robocode.control.RobotSpecification;

public class RepositoryManager
implements IRepositoryManager {
    private static final String DATABASE_FILENAME = "robot.database";
    private final ISettingsManager properties;
    private Repository repository;

    public RepositoryManager(ISettingsManager properties) {
        this.properties = properties;
        properties.addPropertyListener((ISettingsListener)new SettingsListener());
    }

    public File getRobotsDirectory() {
        return FileUtil.getRobotsDir();
    }

    public List<File> getDevelDirectories() {
        ArrayList<File> develDirectories = new ArrayList<File>();
        for (String path : this.properties.getOptionsEnabledDevelopmentPaths()) {
            try {
                develDirectories.add(new File(path).getCanonicalFile());
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
        return develDirectories;
    }

    public void refresh(String friendlyUrl) {
        if (!this.updateItemRoot(friendlyUrl, true)) {
            this.refresh(true);
        }
        URLJarCollector.gc();
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public boolean refresh(boolean force) {
        boolean refreshed = this.update(this.getRobotsDirectory(), this.getDevelDirectories(), force);
        if (refreshed) {
            this.setStatus("Saving robot database");
            this.save();
        }
        this.setStatus("");
        URLJarCollector.gc();
        return refreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(File robotsDir, Collection<File> devDirs, boolean force) {
        int prev = this.repository.getItems().size();
        RootHandler.openHandlers();
        try {
            HashMap<String, IRepositoryRoot> newRoots = new HashMap<String, IRepositoryRoot>();
            RootHandler.visitDirectories(robotsDir, false, newRoots, this.repository, force);
            for (File dir : devDirs) {
                RootHandler.visitDirectories(dir, true, newRoots, this.repository, force);
            }
            this.repository.setRoots(newRoots);
        }
        finally {
            RootHandler.closeHandlers();
        }
        return prev != this.repository.getItems().size();
    }

    private boolean updateItemRoot(String friendlyUrl, boolean force) {
        IRepositoryItem repositoryItem = this.repository.getItems().get(friendlyUrl);
        if (repositoryItem != null) {
            repositoryItem.getRoot().updateItem(repositoryItem, force);
            return true;
        }
        return false;
    }

    private void save() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.getRobotsDirectory(), DATABASE_FILENAME));
            this.repository.save(fos);
            FileUtil.cleanupStream((Object)fos);
        }
        catch (IOException e) {
            Logger.logError((String)"Can't save robot database", (Throwable)e);
        }
        finally {
            FileUtil.cleanupStream(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository load() {
        Repository repository = new Repository();
        FileInputStream fis = null;
        try {
            File file = new File(this.getRobotsDirectory(), DATABASE_FILENAME);
            if (file.exists()) {
                fis = new FileInputStream(file);
                repository.load(fis);
            }
        }
        catch (IOException e) {
            Logger.logError((String)"Can't load robot database", (Throwable)e);
            repository = null;
        }
        finally {
            FileUtil.cleanupStream(fis);
        }
        return repository;
    }

    public void reload(boolean rebuild) {
        URLJarCollector.enableGc((boolean)true);
        URLJarCollector.gc();
        if (rebuild) {
            Logger.logMessage((String)"Rebuilding robot database...");
            this.repository = new Repository();
        } else if (this.repository == null) {
            this.setStatus("Reading robot database");
            this.repository = this.load();
            if (this.repository == null) {
                this.setStatus("Building robot database");
                this.repository = new Repository();
            }
        }
        this.refresh(true);
        this.setStatus("");
    }

    public RobotSpecification[] getSpecifications() {
        this.checkDbExists();
        Collection<IRobotSpecItem> list = this.getAllValidItems();
        ArrayList<RobotSpecification> res = new ArrayList<RobotSpecification>();
        for (IRobotSpecItem s : list) {
            res.add(s.createRobotSpecification());
        }
        return res.toArray(new RobotSpecification[res.size()]);
    }

    public RobotSpecification[] loadSelectedRobots(RobotSpecification[] selectedRobots) {
        this.checkDbExists();
        ArrayList<RobotSpecification> battlingRobotsList = new ArrayList<RobotSpecification>();
        int teamNum = 0;
        for (RobotSpecification spec : selectedRobots) {
            IRobotSpecItem item = (IRobotSpecItem)HiddenAccess.getFileSpecification((RobotSpecification)spec);
            if (item == null) {
                item = this.getRobot(spec.getNameAndVersion());
            }
            this.loadItem(battlingRobotsList, spec, item, teamNum);
            ++teamNum;
        }
        return battlingRobotsList.toArray(new RobotSpecification[battlingRobotsList.size()]);
    }

    public RobotSpecification[] loadSelectedRobots(String selectedRobots) {
        this.checkDbExists();
        ArrayList<RobotSpecification> battlingRobotsList = new ArrayList<RobotSpecification>();
        List<IRobotSpecItem> list = this.getValidItems(selectedRobots);
        int teamNum = 0;
        for (IRobotSpecItem item : list) {
            this.loadItem(battlingRobotsList, null, item, teamNum);
            ++teamNum;
        }
        return battlingRobotsList.toArray(new RobotSpecification[battlingRobotsList.size()]);
    }

    private boolean loadItem(Collection<RobotSpecification> battlingRobotsList, RobotSpecification spec, IRobotSpecItem item, int teamNum) {
        String teamName = String.format("%4d", teamNum);
        if (item != null) {
            if (item.isTeam()) {
                teamName = item.getFullClassNameWithVersion() + "[" + teamName + "]";
                Collection<RobotItem> members = this.getRobotItems((TeamItem)item);
                for (IRobotSpecItem iRobotSpecItem : members) {
                    RobotItem robot = (RobotItem)iRobotSpecItem;
                    boolean tested = false;
                    for (RobotSpecification loaded : battlingRobotsList) {
                        if (!HiddenAccess.getFileSpecification((RobotSpecification)loaded).equals(robot)) continue;
                        tested = true;
                        break;
                    }
                    if (!tested && !robot.validate()) continue;
                    battlingRobotsList.add(robot.createRobotSpecification(null, teamName));
                }
            } else {
                RobotItem robot = (RobotItem)item;
                if (robot.validate()) {
                    battlingRobotsList.add(robot.createRobotSpecification(spec, null));
                } else {
                    Logger.logError((String)("Could not load robot: " + robot.getFullClassName()));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public List<IRobotSpecItem> getSelectedSpecifications(String selectedRobots) {
        this.checkDbExists();
        return this.getValidItems(selectedRobots);
    }

    private Collection<IRobotSpecItem> getAllValidItems() {
        ArrayList<IRobotSpecItem> res = new ArrayList<IRobotSpecItem>();
        for (IRepositoryItem repositoryItem : this.repository.getItems().values()) {
            IRobotSpecItem spec = (IRobotSpecItem)repositoryItem;
            if (!repositoryItem.isValid() || res.contains(spec)) continue;
            res.add(spec);
        }
        return res;
    }

    private List<IRobotSpecItem> getValidItems(String friendlyUrls) {
        ArrayList<IRobotSpecItem> result = new ArrayList<IRobotSpecItem>();
        StringTokenizer tokenizer = new StringTokenizer(friendlyUrls, ",");
        while (tokenizer.hasMoreTokens()) {
            String friendlyUrl = tokenizer.nextToken().trim();
            IRepositoryItem repositoryItem = this.repository.getItem(friendlyUrl);
            if (repositoryItem != null) {
                if (repositoryItem.isValid()) {
                    result.add((IRobotSpecItem)repositoryItem);
                    continue;
                }
                Logger.logError((String)("Can't load '" + friendlyUrl + "' because it is an invalid robot or team."));
                continue;
            }
            Logger.logError((String)("Can't find '" + friendlyUrl + '\''));
        }
        return result;
    }

    public List<IRobotSpecItem> getRepositoryItems(boolean onlyWithSource, boolean onlyWithPackage, boolean onlyRobots, boolean onlyDevelopment, boolean onlyNotDevelopment, boolean ignoreTeamRobots, boolean onlyInJar) {
        this.checkDbExists();
        ArrayList<IRobotSpecItem> res = new ArrayList<IRobotSpecItem>();
        for (IRepositoryItem repositoryItem : this.repository.getItems().values()) {
            IRobotSpecItem spec = (IRobotSpecItem)repositoryItem;
            if (!repositoryItem.isValid() || onlyWithSource && !spec.isSourceIncluded() || onlyWithPackage && spec.getFullPackage() == null || onlyInJar && !spec.isInJAR() || onlyRobots && !(repositoryItem instanceof RobotItem) || onlyDevelopment && !spec.isDevelopmentVersion() || onlyNotDevelopment && spec.isDevelopmentVersion() || res.contains(spec)) continue;
            res.add(spec);
        }
        Collections.sort(res);
        return res;
    }

    public boolean verifyRobotName(String robotName, String shortClassName) {
        return RobotItem.verifyRobotName(robotName, shortClassName, true);
    }

    public int extractJar(IRobotSpecItem item) {
        if (!item.isInJAR()) {
            return -2;
        }
        ((RepositoryItem)item).getRoot().extractJAR();
        return 0;
    }

    public void createTeam(File target, TeamProperties teamProps) throws IOException {
        this.checkDbExists();
        TeamItem.createOrUpdateTeam(target, teamProps);
        this.refresh(target.toURI().toString());
    }

    public String createPackage(File jarFile, List<IRobotSpecItem> selectedRobots, RobotProperties robotProps) {
        this.checkDbExists();
        List<RobotItem> robotItems = this.getAllRobotItems(selectedRobots);
        TeamItem teamItem = RepositoryManager.getTeamItem(selectedRobots);
        String res = JarCreator.createPackage(jarFile, robotItems, teamItem, robotProps);
        this.refresh(jarFile.toURI().toString());
        return res;
    }

    private Collection<RobotItem> getRobotItems(TeamItem team) {
        ArrayList<RobotItem> result = new ArrayList<RobotItem>();
        StringTokenizer teamTokenizer = new StringTokenizer(team.getMembers(), ",");
        while (teamTokenizer.hasMoreTokens()) {
            String botNameAndVersion = teamTokenizer.nextToken();
            int versionIndex = botNameAndVersion.indexOf(32);
            String botPath = versionIndex < 0 ? botNameAndVersion : botNameAndVersion.substring(0, versionIndex);
            botPath = botPath.replace('.', '/').replaceAll("\\*", "");
            String teamBot = team.getRoot().getURL() + botPath;
            IRepositoryItem res = this.repository.getItem(teamBot);
            if (res != null && res instanceof RobotItem) {
                result.add((RobotItem)res);
                continue;
            }
            res = this.repository.getItem(botNameAndVersion);
            if (res != null && res instanceof RobotItem) {
                result.add((RobotItem)res);
                continue;
            }
            Logger.logError((String)("Can't find robot: " + botNameAndVersion));
        }
        return result;
    }

    private List<RobotItem> getAllRobotItems(Collection<IRobotSpecItem> items) {
        ArrayList<RobotItem> result = new ArrayList<RobotItem>();
        for (IRobotSpecItem item : items) {
            if (item.isTeam()) {
                result.addAll(this.getRobotItems((TeamItem)item));
                continue;
            }
            result.add((RobotItem)item);
        }
        return result;
    }

    private static TeamItem getTeamItem(Collection<IRobotSpecItem> items) {
        for (IRobotSpecItem item : items) {
            if (!item.isTeam()) continue;
            return (TeamItem)item;
        }
        return null;
    }

    private IRobotSpecItem getRobot(String fullClassNameWithVersion) {
        IRepositoryItem repositoryItem = this.repository.getItem(fullClassNameWithVersion);
        if (repositoryItem == null || !repositoryItem.isValid()) {
            return null;
        }
        return (IRobotSpecItem)repositoryItem;
    }

    private void setStatus(String message) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
        if (message.length() > 0) {
            Logger.logMessage((String)message);
        }
    }

    private void checkDbExists() {
        if (this.repository == null) {
            this.reload(false);
        }
    }

    private class SettingsListener
    implements ISettingsListener {
        private Collection<String> lastEnabledDevelPaths;

        private SettingsListener() {
        }

        public void settingChanged(String property) {
            if (property.equals("robocode.options.development.path") || property.equals("robocode.options.development.path.excluded")) {
                Collection enabledDevelPaths = RepositoryManager.this.properties.getOptionsEnabledDevelopmentPaths();
                if (this.lastEnabledDevelPaths == null || !enabledDevelPaths.equals(this.lastEnabledDevelPaths)) {
                    this.lastEnabledDevelPaths = enabledDevelPaths;
                    RepositoryManager.this.reload(false);
                }
            }
        }
    }
}

