/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.io.Serializable;
import java.net.URL;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.root.IRepositoryRoot;

public abstract class RepositoryItem
implements IRepositoryItem,
Serializable {
    private static final long serialVersionUID = 1L;
    protected URL itemUrl;
    protected IRepositoryRoot root;
    protected long lastModified;
    protected boolean isValid;

    RepositoryItem(URL itemURL, IRepositoryRoot root) {
        this.itemUrl = itemURL;
        this.root = root;
        this.lastModified = 0L;
    }

    @Override
    public URL getItemURL() {
        return this.itemUrl;
    }

    @Override
    public IRepositoryRoot getRoot() {
        return this.root;
    }

    public boolean isInJAR() {
        return this.root.isJAR();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public int hashCode() {
        return 31 + (this.itemUrl == null ? 0 : this.itemUrl.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepositoryItem)) {
            return false;
        }
        RepositoryItem other = (RepositoryItem)obj;
        if (this.itemUrl == null && other.itemUrl != null) {
            return false;
        }
        return this.itemUrl.equals(other.itemUrl);
    }
}

