/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.RobocodeProperties;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRobotItem;
import net.sf.robocode.repository.RobotProperties;
import net.sf.robocode.repository.RobotType;
import net.sf.robocode.repository.items.RobotSpecItem;
import net.sf.robocode.repository.root.ClasspathRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.version.IVersionManager;
import robocode.control.RobotSpecification;

public class RobotItem
extends RobotSpecItem
implements IRobotItem {
    private static final long serialVersionUID = 1L;
    private static final int MAX_FULL_PACKAGE_NAME_LENGTH = 32;
    private static final int MAX_SHORT_CLASS_NAME_LENGTH = 32;
    protected static final String ROBOT_PLATFORM = "robot.platform";
    private static final String ROBOT_CLASSNAME = "robot.classname";
    private static final String ROBOT_VERSION = "robot.version";
    private static final String ROBOT_DESCRIPTION = "robot.description";
    private static final String ROBOT_AUTHOR_NAME = "robot.author.name";
    private static final String ROBOT_WEBPAGE = "robot.webpage";
    private static final String ROBOCODE_VERSION = "robocode.version";
    private static final String ROBOT_INCLUDE_SOURCE = "robot.include.source";
    private static final String ROBOT_INCLUDE_DATA = "robot.include.data";
    private static final String ROBOT_CODESIZE = "robot.codesize";
    private static final String CLASS_EXTENSION = ".class";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String HTML_EXTENSION = ".html";
    private static final boolean ALWAYS_USE_CACHE_FOR_DATA = System.getProperty("ALWAYSUSECACHEFORDATA", "false").equals("true");
    private RobotType robotType;
    private URL classPathURL;
    private Set<URL> sourcePathURLs;
    private URL classURL;
    private URL propertiesURL;
    private String className;
    protected boolean isPropertiesLoaded;

    public RobotItem(URL itemURL, IRepositoryRoot root) {
        super(itemURL, root);
        this.isValid = true;
        this.classPathURL = root.getURL();
        this.sourcePathURLs = new HashSet<URL>();
    }

    private void populate() {
        this.populatePropertiesURLFromClassURL();
        this.populateClassURLFromPropertiesURL();
        this.loadProperties();
    }

    public void setClassURL(URL classUrl) {
        this.classURL = classUrl;
        this.populate();
    }

    public void setPropertiesURL(URL propertiesUrl) {
        this.propertiesURL = propertiesUrl;
        this.populate();
    }

    public void setClassPathURL(URL classPathUrl) {
        this.classPathURL = classPathUrl;
    }

    public void addSourcePathURL(URL sourcePathUrl) {
        this.sourcePathURLs.add(sourcePathUrl);
    }

    private void populatePropertiesURLFromClassURL() {
        if (this.propertiesURL == null && this.classURL != null) {
            String path = this.classURL.toString().replaceFirst("\\.class", PROPERTIES_EXTENSION);
            try {
                this.propertiesURL = new URL(path);
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
            }
            if (this.isInvalidURL(this.propertiesURL)) {
                this.propertiesURL = null;
            }
        }
    }

    private void populateClassURLFromPropertiesURL() {
        if (this.classURL == null && this.propertiesURL != null) {
            String path = this.propertiesURL.toString().replaceAll("\\.properties", CLASS_EXTENSION);
            try {
                this.classURL = new URL(path);
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
            }
            if (this.isInvalidURL(this.classURL)) {
                this.classURL = null;
            }
        }
    }

    private void populateClassNameFromClassURL() {
        this.populate();
        if (this.className == null && this.classURL != null) {
            String path = this.classURL.toString();
            int index = path.toLowerCase().indexOf(".dll!/");
            if (index > 0) {
                this.className = path.substring(index + 6);
                return;
            }
            index = path.lastIndexOf(33);
            this.className = index > 0 ? path.substring(index + 2) : path.substring(this.root.getURL().toString().length());
            index = this.className.lastIndexOf(46);
            if (index > 0) {
                this.className = this.className.substring(0, index);
            }
            this.className = this.className.replaceAll("[\\\\\\/]", ".");
        }
    }

    private void populateHtmlURL() {
        this.populate();
        if (this.htmlURL == null && this.classURL != null) {
            try {
                this.htmlURL = new URL(this.classURL.toString().replaceFirst(CLASS_EXTENSION, HTML_EXTENSION));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.htmlURL == null && this.propertiesURL != null) {
            try {
                this.htmlURL = new URL(this.propertiesURL.toString().replaceFirst(PROPERTIES_EXTENSION, HTML_EXTENSION));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.isInvalidURL(this.htmlURL)) {
            this.htmlURL = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInvalidURL(URL url) {
        if (url != null) {
            boolean bl;
            InputStream is = null;
            try {
                URLConnection conn = URLJarCollector.openConnection((URL)url);
                is = conn.getInputStream();
                bl = false;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(is);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)is);
                return bl2;
            }
            FileUtil.cleanupStream((Object)is);
            return bl;
        }
        return true;
    }

    public boolean isTeam() {
        return false;
    }

    @Override
    public URL getHtmlURL() {
        if (this.htmlURL == null) {
            this.populateHtmlURL();
        }
        return this.htmlURL;
    }

    @Override
    public URL getPropertiesURL() {
        if (this.propertiesURL == null) {
            this.populatePropertiesURLFromClassURL();
        }
        return this.propertiesURL;
    }

    @Override
    public Set<String> getFriendlyURLs() {
        String friendly;
        this.populate();
        HashSet<String> urls = new HashSet<String>();
        URL url = null;
        if (this.classURL != null) {
            url = this.classURL;
        } else if (this.propertiesURL != null) {
            url = this.propertiesURL;
        }
        if (url != null) {
            String sUrl = url.toString();
            String urlNoType = sUrl.substring(0, sUrl.lastIndexOf(46));
            String path = url.getPath();
            String pathNoType = path.substring(0, path.lastIndexOf(46));
            urls.add(urlNoType);
            urls.add(pathNoType);
        }
        if (this.getFullClassName() != null) {
            if (RobocodeProperties.isTestingOn()) {
                urls.add(this.getFullClassName());
            } else {
                urls.add(this.getUniqueFullClassName());
            }
            urls.add(this.getUniqueFullClassNameWithVersion());
        }
        if (this.root.isJAR()) {
            urls.add(this.root.getURL().toString());
        }
        if (this.root instanceof ClasspathRoot && (friendly = ((ClasspathRoot)this.root).getFriendlyProjectURL(this.itemUrl)) != null) {
            urls.add(friendly);
        }
        return urls;
    }

    @Override
    public void update(long lastModified, boolean force) {
        if (lastModified > this.lastModified || force) {
            if (force) {
                this.isValid = true;
            }
            if (this.isValid) {
                this.validateType(false);
            }
            this.lastModified = lastModified;
            if (this.classURL == null) {
                this.isValid = false;
            }
            this.loadProperties();
            if (!this.isTeamRobot() && this.root.isJAR() && !this.isPropertiesLoaded) {
                this.isValid = false;
            }
            if (this.isValid) {
                this.verifyName();
            }
        }
    }

    protected void validateType(boolean resolve) {
        this.populate();
        IHostManager hostManager = (IHostManager)Container.getComponent(IHostManager.class);
        this.robotType = hostManager.getRobotType((IRobotItem)this, resolve, this.classURL != null);
        if (!this.robotType.isValid()) {
            this.isValid = false;
        }
    }

    public boolean validate() {
        this.validateType(true);
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties() {
        if (!this.isPropertiesLoaded && this.propertiesURL != null) {
            boolean bl;
            InputStream ios = null;
            try {
                URLConnection con = URLJarCollector.openConnection((URL)this.propertiesURL);
                ios = con.getInputStream();
                this.properties.load(ios);
                this.isPropertiesLoaded = true;
                bl = true;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(ios);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)ios);
                return bl2;
            }
            FileUtil.cleanupStream((Object)ios);
            return bl;
        }
        return false;
    }

    private boolean verifyName() {
        String shortClassName;
        String robotName = this.getFullClassName();
        boolean valid = RobotItem.verifyRobotName(robotName, shortClassName = this.getShortClassName(), false);
        if (!valid) {
            this.isValid = false;
        }
        return valid;
    }

    public static boolean verifyRobotName(String fullClassName, String shortClassName, boolean silent) {
        if (fullClassName == null || fullClassName.length() == 0 || fullClassName.contains("$")) {
            return false;
        }
        int lIndex = fullClassName.indexOf(".");
        if (lIndex > 0) {
            String rootPackage = fullClassName.substring(0, lIndex);
            if (rootPackage.equalsIgnoreCase("robocode")) {
                if (!silent) {
                    Logger.logError((String)("Robot " + fullClassName + " ignored.  You cannot use package " + rootPackage));
                }
                return false;
            }
            if (rootPackage.length() > 32) {
                if (!silent) {
                    Logger.logError((String)("Robot " + fullClassName + " has package name too long.  " + 32 + " characters maximum please."));
                }
                return false;
            }
        }
        if (shortClassName != null && shortClassName.length() > 32) {
            if (!silent) {
                Logger.logError((String)("Robot " + fullClassName + " has classname too long.  " + 32 + " characters maximum please."));
            }
            return false;
        }
        return true;
    }

    public void storeProperties(OutputStream os, RobotProperties robotProps) throws IOException {
        if (this.className != null) {
            this.properties.setProperty(ROBOT_CLASSNAME, this.className);
        }
        if (robotProps.getVersion() != null) {
            this.properties.setProperty(ROBOT_VERSION, robotProps.getVersion());
        }
        if (robotProps.getDescription() != null) {
            this.properties.setProperty(ROBOT_DESCRIPTION, robotProps.getDescription());
        }
        if (robotProps.getAuthor() != null) {
            this.properties.setProperty(ROBOT_AUTHOR_NAME, robotProps.getAuthor());
        }
        if (robotProps.getWebPage() != null) {
            this.properties.setProperty(ROBOT_WEBPAGE, robotProps.getWebPage().toExternalForm());
        }
        if (robotProps.getCodeSize() != null) {
            this.properties.setProperty(ROBOT_CODESIZE, "" + robotProps.getCodeSize());
        }
        this.properties.setProperty(ROBOT_INCLUDE_SOURCE, "" + robotProps.isIncludeSource());
        String version = ((IVersionManager)Container.getComponent(IVersionManager.class)).getVersion();
        this.properties.setProperty(ROBOCODE_VERSION, version);
        this.saveProperties(os);
        this.saveProperties();
    }

    private void saveProperties(OutputStream os) throws IOException {
        this.properties.store(os, "Robocode Robot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties() {
        File file = new File(this.root.getPath(), this.className.replaceAll("\\.", "/") + PROPERTIES_EXTENSION);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.saveProperties(fos);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream(fos);
                throw throwable;
            }
            FileUtil.cleanupStream((Object)fos);
        }
        FileUtil.cleanupStream((Object)fos);
        this.populatePropertiesURLFromClassURL();
    }

    public boolean isJuniorRobot() {
        return this.robotType.isJuniorRobot();
    }

    public boolean isStandardRobot() {
        return this.robotType.isStandardRobot();
    }

    public boolean isAdvancedRobot() {
        return this.robotType.isAdvancedRobot();
    }

    public boolean isTeamRobot() {
        return this.robotType.isTeamRobot();
    }

    public boolean isDroid() {
        return this.robotType.isDroid();
    }

    public boolean isSentryRobot() {
        return this.robotType.isSentryRobot();
    }

    public boolean isInteractiveRobot() {
        return this.robotType.isInteractiveRobot();
    }

    public boolean isPaintRobot() {
        return this.robotType.isPaintRobot();
    }

    public URL getClassPathURL() {
        return this.classPathURL;
    }

    public URL[] getSourcePathURLs() {
        if (this.sourcePathURLs.size() == 0) {
            return new URL[]{this.classPathURL};
        }
        return this.sourcePathURLs.toArray(new URL[0]);
    }

    @Override
    public String getFullClassName() {
        if (this.className == null) {
            this.populateClassNameFromClassURL();
        }
        return this.className;
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty(ROBOT_VERSION, null);
    }

    @Override
    public String getDescription() {
        return this.properties.getProperty(ROBOT_DESCRIPTION, null);
    }

    @Override
    public String getAuthorName() {
        return this.properties.getProperty(ROBOT_AUTHOR_NAME, null);
    }

    public String getPlatform() {
        return this.properties.getProperty(ROBOT_PLATFORM, "Java");
    }

    @Override
    public URL getWebpage() {
        try {
            String webPage = this.properties.getProperty(ROBOT_WEBPAGE, null);
            if (webPage == null || webPage.trim().isEmpty()) {
                return null;
            }
            return new URL(webPage);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Integer getCodeSize() {
        String value = this.properties.getProperty(ROBOT_CODESIZE);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean getIncludeSource() {
        return this.properties.getProperty(ROBOT_INCLUDE_SOURCE, "true").equalsIgnoreCase("true");
    }

    public boolean getIncludeData() {
        return this.properties.getProperty(ROBOT_INCLUDE_DATA, "true").equalsIgnoreCase("true");
    }

    public boolean isSourceIncluded() {
        return this.sourcePathURLs.size() > 0;
    }

    @Override
    public String getRobocodeVersion() {
        return this.properties.getProperty(ROBOCODE_VERSION, null);
    }

    public String getReadableDirectory() {
        String path;
        if (this.root.isJAR()) {
            String jarFile = this.getClassPathURL().getFile();
            jarFile = jarFile.substring(jarFile.lastIndexOf(47) + 1, jarFile.length());
            path = FileUtil.getRobotsDataDir().getPath();
            if (jarFile.length() > 0) {
                path = path + File.separator + jarFile + '_';
            }
        } else {
            path = this.getClassPathURL().getFile();
        }
        if (this.getFullPackage() != null) {
            path = path + File.separator + this.getFullPackage().replace('.', File.separatorChar);
        }
        return path;
    }

    public String getWritableDirectory() {
        String path;
        if (this.root.isJAR()) {
            String jarFile = this.getClassPathURL().getFile();
            jarFile = jarFile.substring(jarFile.lastIndexOf(47) + 1, jarFile.length());
            path = FileUtil.getRobotsDataDir().getPath();
            if (jarFile.length() > 0) {
                path = path + File.separator + jarFile + '_';
            }
        } else {
            String string = path = ALWAYS_USE_CACHE_FOR_DATA ? FileUtil.getRobotsDataDir().getPath() : this.getClassPathURL().getFile();
        }
        if (this.getFullPackage() != null) {
            path = path + File.separator + this.getFullPackage().replace('.', File.separatorChar);
        }
        return path;
    }

    public RobotSpecification createRobotSpecification(RobotSpecification battleRobotSpec, String teamName) {
        RobotSpecification specification = battleRobotSpec != null ? battleRobotSpec : this.createRobotSpecification();
        if (teamName != null) {
            HiddenAccess.setTeamName((RobotSpecification)specification, (String)teamName);
        }
        return specification;
    }

    public String toString() {
        return this.itemUrl.toString();
    }
}

