/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.repository.items.RepositoryItem;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.util.AlphanumericComparator;
import robocode.control.RobotSpecification;

public abstract class RobotSpecItem
extends RepositoryItem
implements IRobotSpecItem {
    private static final long serialVersionUID = 1L;
    protected Properties properties = new Properties();
    protected URL htmlURL;

    RobotSpecItem(URL itemURL, IRepositoryRoot root) {
        super(itemURL, root);
    }

    public abstract URL getPropertiesURL();

    public abstract String getFullClassName();

    public abstract String getVersion();

    public abstract URL getWebpage();

    public abstract String getAuthorName();

    public abstract String getRobocodeVersion();

    public abstract String getDescription();

    public abstract URL getHtmlURL();

    public boolean isDevelopmentVersion() {
        return this.root.isDevelopmentRoot() && !this.getFullClassName().startsWith("sample") && !this.getFullClassName().startsWith("tested.");
    }

    public String getRootPath() {
        return this.root.getURL().toString();
    }

    public String getRootPackage() {
        int lIndex = this.getFullClassName().indexOf(".");
        String rootPackage = null;
        if (lIndex > 0) {
            rootPackage = this.getFullClassName().substring(0, lIndex);
        }
        return rootPackage;
    }

    public String getFullPackage() {
        if (this.getFullClassName() == null) {
            return null;
        }
        int index = this.getFullClassName().lastIndexOf(46);
        return index >= 0 ? this.getFullClassName().substring(0, index) : null;
    }

    public String getRelativePath() {
        int index = this.getFullClassName().lastIndexOf(46);
        return index < 0 ? "" : this.getFullClassName().substring(0, index).replaceAll("\\.", "/");
    }

    public String getShortClassName() {
        if (this.getFullClassName() == null) {
            return null;
        }
        int index = this.getFullClassName().lastIndexOf(46);
        if (index == -1) {
            return this.getFullClassName();
        }
        return this.getFullClassName().substring(index + 1);
    }

    public String getFullClassNameWithVersion() {
        String fullClassName = this.getFullClassName();
        if (this.getVersion() != null) {
            fullClassName = fullClassName + " " + this.getVersion();
        }
        return fullClassName;
    }

    public String getUniqueFullClassName() {
        String uniqueFullClassName = this.getFullClassName();
        if (this.isDevelopmentVersion()) {
            uniqueFullClassName = uniqueFullClassName + '*';
        }
        return uniqueFullClassName;
    }

    public String getUniqueFullClassNameWithVersion() {
        String uniqueFullClassName;
        String string = uniqueFullClassName = this.getVersion() == null ? this.getFullClassName() : this.getFullClassNameWithVersion();
        if (this.isDevelopmentVersion()) {
            uniqueFullClassName = uniqueFullClassName + '*';
        }
        return uniqueFullClassName;
    }

    public String getUniqueShortClassNameWithVersion() {
        String uniqueShortClassName;
        String string = uniqueShortClassName = this.getVersion() == null ? this.getShortClassName() : this.getShortClassNameWithVersion();
        if (this.isDevelopmentVersion()) {
            uniqueShortClassName = uniqueShortClassName + '*';
        }
        return uniqueShortClassName;
    }

    public String getUniqueVeryShortClassNameWithVersion() {
        String veryShortClassName;
        String string = veryShortClassName = this.getVersion() == null ? this.getVeryShortClassName() : this.getVeryShortClassNameWithVersion();
        if (this.isDevelopmentVersion()) {
            veryShortClassName = veryShortClassName + '*';
        }
        return veryShortClassName;
    }

    public String getShortClassNameWithVersion() {
        String shortClassName = this.getShortClassName();
        if (this.getVersion() != null) {
            shortClassName = shortClassName + " " + this.getVersion();
        }
        return shortClassName;
    }

    public String getVeryShortClassNameWithVersion() {
        String veryShortClassName = this.getVeryShortClassName();
        if (this.getVersion() != null) {
            veryShortClassName = veryShortClassName + " " + this.getVersion();
        }
        return veryShortClassName;
    }

    public String getVeryShortClassName() {
        String veryShortClassName = this.getShortClassName();
        if (veryShortClassName.length() > 12) {
            veryShortClassName = veryShortClassName.substring(0, 12) + "...";
        }
        return veryShortClassName;
    }

    public RobotSpecification createRobotSpecification() {
        return HiddenAccess.createSpecification((Object)this, (String)this.getUniqueFullClassName(), (String)this.getAuthorName(), (String)(this.getWebpage() != null ? this.getWebpage().toString() : null), (String)this.getVersion(), (String)this.getRobocodeVersion(), (String)this.root.getURL().toString(), (String)this.getFullClassName(), (String)this.getDescription());
    }

    @Override
    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof IRobotSpecItem) {
            IRobotSpecItem otherRI = (IRobotSpecItem)other;
            return RobotSpecItem.compare(this.getFullPackage(), this.getFullClassName(), this.getVersion(), otherRI.getFullPackage(), otherRI.getFullClassName(), otherRI.getVersion());
        }
        return 0;
    }

    private static int compare(String p1, String c1, String v1, String p2, String c2, String v2) {
        AlphanumericComparator alphaNumComparator = new AlphanumericComparator();
        int result = alphaNumComparator.compare(p1, p2);
        if (result != 0) {
            return result;
        }
        result = alphaNumComparator.compare(c1, c2);
        if (result != 0) {
            return result;
        }
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        if (v1.equals(v2)) {
            return 0;
        }
        if (v1.indexOf(".") < 0 || v2.indexOf(".") < 0) {
            return alphaNumComparator.compare(v1, v2);
        }
        StringTokenizer s1 = new StringTokenizer(v1, ".");
        StringTokenizer s2 = new StringTokenizer(v2, ".");
        while (s1.hasMoreTokens() && s2.hasMoreTokens()) {
            String tok1 = s1.nextToken();
            String tok2 = s2.nextToken();
            try {
                int i2;
                int i1 = Integer.parseInt(tok1);
                if (i1 == (i2 = Integer.parseInt(tok2))) continue;
                return i1 - i2;
            }
            catch (NumberFormatException e) {
                int tc = alphaNumComparator.compare(tok1, tok2);
                if (tc == 0) continue;
                return tc;
            }
        }
        if (s1.hasMoreTokens()) {
            return 1;
        }
        if (s2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }
}

