/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.RobocodeProperties;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.repository.RobotProperties;
import net.sf.robocode.repository.TeamProperties;
import net.sf.robocode.repository.items.RobotSpecItem;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.version.IVersionManager;

public class TeamItem
extends RobotSpecItem
implements IRobotSpecItem {
    private static final long serialVersionUID = 1L;
    private static final String TEAM_DESCRIPTION = "team.description";
    private static final String TEAM_AUTHOR_NAME = "team.author.name";
    private static final String TEAM_VERSION = "team.version";
    private static final String TEAM_WEBPAGE = "team.webpage";
    private static final String TEAM_MEMBERS = "team.members";
    private static final String ROBOCODE_VERSION = "robocode.version";
    private final String fullTeamName;

    public TeamItem(URL itemURL, IRepositoryRoot root) {
        super(itemURL, root);
        String tUrl = itemURL.toString();
        tUrl = tUrl.substring(0, tUrl.lastIndexOf(".team"));
        int versionSeparator = tUrl.lastIndexOf(" ");
        int rootLen = root.getURL().toString().length();
        this.fullTeamName = versionSeparator != -1 ? tUrl.substring(rootLen, versionSeparator).replace('/', '.').replace('\\', '.') : tUrl.substring(rootLen).replace('/', '.').replace('\\', '.');
        if (this.loadProperties()) {
            this.isValid = true;
        }
    }

    private void htmlURLFromPropertiesURL() {
        try {
            this.htmlURL = new URL(this.itemUrl.toString().replaceAll("\\.team", ".html"));
            URLConnection conn = URLJarCollector.openConnection((URL)this.htmlURL);
            conn.getInputStream().close();
        }
        catch (IOException ignored) {
            this.htmlURL = null;
        }
    }

    @Override
    public Set<String> getFriendlyURLs() {
        HashSet<String> urls = new HashSet<String>();
        if (this.itemUrl != null) {
            String url = this.itemUrl.toString();
            String urlNoType = url.substring(0, url.lastIndexOf(46));
            String path = this.itemUrl.getPath();
            String pathNoType = path.substring(0, path.lastIndexOf(46));
            urls.add(urlNoType);
            urls.add(pathNoType);
        }
        if (RobocodeProperties.isTestingOn()) {
            urls.add(this.getFullClassName());
        } else {
            urls.add(this.getUniqueFullClassName());
        }
        urls.add(this.getUniqueFullClassNameWithVersion());
        return urls;
    }

    @Override
    public void update(long lastModified, boolean force) {
        if (lastModified > this.lastModified || force) {
            this.lastModified = lastModified;
            this.loadProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties() {
        if (this.itemUrl != null) {
            boolean bl;
            InputStream ios = null;
            try {
                URLConnection connection = URLJarCollector.openConnection((URL)this.itemUrl);
                ios = connection.getInputStream();
                this.properties.load(ios);
                bl = true;
            }
            catch (IOException e) {
                try {
                    Logger.logError((Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(ios);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)ios);
            }
            FileUtil.cleanupStream((Object)ios);
            return bl;
        }
        return false;
    }

    @Override
    public URL getHtmlURL() {
        if (this.htmlURL == null) {
            this.htmlURLFromPropertiesURL();
        }
        return this.htmlURL;
    }

    @Override
    public URL getPropertiesURL() {
        return this.itemUrl;
    }

    public boolean isTeam() {
        return true;
    }

    @Override
    public String getFullClassName() {
        return this.fullTeamName;
    }

    public String getMembers() {
        return this.properties.getProperty(TEAM_MEMBERS, null);
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty(TEAM_VERSION, null);
    }

    @Override
    public String getDescription() {
        return this.properties.getProperty(TEAM_DESCRIPTION, null);
    }

    @Override
    public String getAuthorName() {
        return this.properties.getProperty(TEAM_AUTHOR_NAME, null);
    }

    @Override
    public URL getWebpage() {
        try {
            return new URL(this.properties.getProperty(TEAM_WEBPAGE, null));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean getIncludeSource() {
        return false;
    }

    public boolean getIncludeData() {
        return false;
    }

    public boolean isSourceIncluded() {
        return false;
    }

    @Override
    public String getRobocodeVersion() {
        return this.properties.getProperty(ROBOCODE_VERSION, null);
    }

    public String toString() {
        return this.itemUrl.toString();
    }

    public void storeProperties(OutputStream os, RobotProperties props) throws IOException {
        if (props.getVersion() != null) {
            this.properties.setProperty(TEAM_VERSION, props.getVersion());
        }
        if (props.getAuthor() != null) {
            this.properties.setProperty(TEAM_AUTHOR_NAME, props.getAuthor());
        }
        if (props.getDescription() != null) {
            this.properties.setProperty(TEAM_DESCRIPTION, props.getDescription());
        }
        if (props.getWebPage() != null) {
            this.properties.setProperty(TEAM_WEBPAGE, props.getWebPage().toExternalForm());
        }
        this.properties.setProperty(ROBOCODE_VERSION, ((IVersionManager)Container.getComponent(IVersionManager.class)).getVersion());
        this.properties.store(os, "Robocode Robot Team");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOrUpdateTeam(File target, TeamProperties props) throws IOException {
        FileOutputStream os = null;
        try {
            Properties team = TeamItem.loadTeamProperties(target);
            if (props.getVersion() != null) {
                team.setProperty(TEAM_VERSION, props.getVersion());
            }
            if (props.getMembers() != null) {
                team.setProperty(TEAM_MEMBERS, props.getMembers());
            }
            if (props.getAuthor() != null) {
                team.setProperty(TEAM_AUTHOR_NAME, props.getAuthor());
            }
            if (props.getDescription() != null) {
                team.setProperty(TEAM_DESCRIPTION, props.getDescription());
            }
            if (props.getWebPage() != null) {
                team.setProperty(TEAM_WEBPAGE, props.getWebPage().toExternalForm());
            }
            String version = ((IVersionManager)Container.getComponent(IVersionManager.class)).getVersion();
            team.setProperty(ROBOCODE_VERSION, version);
            os = new FileOutputStream(target);
            team.store(os, "Robocode robot team");
        }
        catch (Throwable throwable) {
            FileUtil.cleanupStream(os);
            throw throwable;
        }
        FileUtil.cleanupStream((Object)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadTeamProperties(File target) {
        Properties team = new Properties();
        if (target.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(target);
                team.load(fis);
            }
            catch (Exception e) {
                try {
                    Logger.logError((Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(fis);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)fis);
            }
            FileUtil.cleanupStream((Object)fis);
        }
        return team;
    }
}

