/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.util.UrlUtil;

public class ClassHandler
extends ItemHandler {
    @Override
    protected IRepositoryItem acceptItem(URL itemURL, IRepositoryRoot root, IRepository repository) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".class") && !name.contains("$")) {
            return this.register(itemURL, root, repository);
        }
        return null;
    }

    private RobotItem register(URL classFileUrl, IRepositoryRoot root, IRepository repository) {
        RobotItem item = null;
        String friendlyUrl = UrlUtil.removeFileExtension((String)classFileUrl.toString());
        IRepositoryItem repositoryItem = repository.getItem(friendlyUrl);
        if (repositoryItem instanceof RobotItem) {
            item = (RobotItem)repositoryItem;
        }
        if (item == null) {
            item = new RobotItem(classFileUrl, root);
        }
        item.setClassPathURL(root.getURL());
        item.setClassURL(classFileUrl);
        repository.addOrUpdateItem(item);
        return item;
    }
}

