/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.util.UrlUtil;

public class PropertiesHandler
extends ItemHandler {
    @Override
    protected IRepositoryItem acceptItem(URL itemURL, IRepositoryRoot root, IRepository repository) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".properties")) {
            return this.register(itemURL, root, repository);
        }
        return null;
    }

    private RobotItem register(URL propertiesFileUrl, IRepositoryRoot root, IRepository repository) {
        RobotItem item = null;
        String friendlyUrl = UrlUtil.removeFileExtension((String)propertiesFileUrl.toString());
        IRepositoryItem repositoryItem = repository.getItem(friendlyUrl);
        if (repositoryItem instanceof RobotItem) {
            item = (RobotItem)repositoryItem;
        }
        if (item == null) {
            item = this.createRobotItem(propertiesFileUrl, root, repository);
        }
        if (item != null) {
            repository.addOrUpdateItem(item);
        }
        return item;
    }

    private RobotItem createRobotItem(URL propertiesFileUrl, IRepositoryRoot root, IRepository repository) {
        RobotItem item = new RobotItem(propertiesFileUrl, root);
        String platform = item.getPlatform();
        if (!platform.equalsIgnoreCase("Java")) {
            PropertiesHandler otherHandler = (PropertiesHandler)Container.getComponent(PropertiesHandler.class, (String)(platform + "PropertiesHandler"));
            return otherHandler == null ? null : otherHandler.createRobotItem(propertiesFileUrl, root, repository);
        }
        item.setPropertiesURL(propertiesFileUrl);
        return item;
    }
}

