/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.ClasspathRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.util.UrlUtil;

public class SourceHandler
extends ItemHandler {
    @Override
    protected IRepositoryItem acceptItem(URL itemURL, IRepositoryRoot root, IRepository repository) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".java") && !name.contains("$")) {
            return this.register(itemURL, root, repository);
        }
        return null;
    }

    private RobotItem register(URL sourceFileUrl, IRepositoryRoot root, IRepository repository) {
        String friendlyUrl;
        IRepositoryItem repositoryItem;
        String projectUrl;
        RobotItem item = null;
        if (root instanceof ClasspathRoot && (projectUrl = ((ClasspathRoot)root).getFriendlyProjectURL(sourceFileUrl)) != null && (repositoryItem = repository.getItem(projectUrl)) instanceof RobotItem) {
            item = (RobotItem)repositoryItem;
        }
        if (item == null && (repositoryItem = repository.getItem(friendlyUrl = UrlUtil.removeFileExtension((String)sourceFileUrl.toString()))) instanceof RobotItem) {
            item = (RobotItem)repositoryItem;
        }
        if (item == null) {
            item = new RobotItem(sourceFileUrl, root);
        }
        item.addSourcePathURL(root.getURL());
        repository.addOrUpdateItem(item);
        return item;
    }
}

