/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.items.handlers;

import java.net.URL;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.TeamItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.util.UrlUtil;

public class TeamHandler
extends ItemHandler {
    @Override
    protected IRepositoryItem acceptItem(URL itemURL, IRepositoryRoot root, IRepository repository) {
        String name = itemURL.toString().toLowerCase();
        if (name.endsWith(".team")) {
            return this.register(itemURL, root, repository);
        }
        return null;
    }

    private TeamItem register(URL teamFileUrl, IRepositoryRoot root, IRepository repository) {
        TeamItem item = null;
        String friendlyUrl = UrlUtil.removeFileExtension((String)teamFileUrl.toString());
        IRepositoryItem repositoryItem = repository.getItem(friendlyUrl);
        if (repositoryItem instanceof TeamItem) {
            item = (TeamItem)repositoryItem;
        }
        if (item == null) {
            item = new TeamItem(teamFileUrl, root);
        }
        repository.addOrUpdateItem(item);
        return item;
    }
}

