/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.packager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.CodeSizeCalculator;
import net.sf.robocode.repository.IRobotItem;
import net.sf.robocode.repository.RobotProperties;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.TeamItem;
import net.sf.robocode.version.IVersionManager;

public class JarCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPackage(File jarFile, List<RobotItem> robotItems, TeamItem teamItem, RobotProperties props) {
        HashSet<String> jarEntries;
        block7: {
            JarOutputStream jarOut = null;
            FileOutputStream fos = null;
            jarEntries = new HashSet<String>();
            try {
                fos = new FileOutputStream(jarFile);
                jarOut = new JarOutputStream((OutputStream)fos, JarCreator.createManifest(robotItems));
                String rVersion = ((IVersionManager)Container.getComponent(IVersionManager.class)).getVersion();
                jarOut.setComment(rVersion + " - Robocode version");
                boolean isTeam = teamItem != null;
                JarCreator.addRobotItemToJar(jarOut, jarEntries, robotItems, props, isTeam);
                if (isTeam) {
                    JarCreator.addTeamItemToJar(jarOut, jarEntries, teamItem, props);
                }
                FileUtil.cleanupStream((Object)jarOut);
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
                break block7;
            }
            finally {
                FileUtil.cleanupStream(jarOut);
                FileUtil.cleanupStream((Object)fos);
            }
            FileUtil.cleanupStream((Object)fos);
        }
        StringBuilder sb = new StringBuilder();
        for (String entry : jarEntries) {
            sb.append(entry).append('\n');
        }
        JarCreator.appendCodeSize(jarFile, sb);
        return sb.toString();
    }

    private static Manifest createManifest(List<RobotItem> robots) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        StringBuilder robotsString = new StringBuilder();
        for (int i = 0; i < robots.size(); ++i) {
            robotsString.append(robots.get(i).getFullClassName());
            if (i >= robots.size() - 1) continue;
            robotsString.append(',');
        }
        manifest.getMainAttributes().put(new Attributes.Name("robots"), robotsString.toString());
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRobotItemToJar(JarOutputStream target, Set<String> jarEntries, List<? extends IRobotItem> robotItems, RobotProperties props, boolean isTeam) throws IOException {
        for (IRobotItem iRobotItem : robotItems) {
            String path = iRobotItem.getRelativePath() + '/' + iRobotItem.getShortClassName() + ".properties";
            String classPath = iRobotItem.getClassPathURL().getPath();
            File dir = new File(classPath, iRobotItem.getRelativePath());
            Integer codeSize = CodeSizeCalculator.getDirectoryCodeSize((File)dir);
            props.setCodeSize(codeSize);
            if (!isTeam) {
                FileOutputStream fis = null;
                try {
                    File file = new File(classPath, path);
                    fis = new FileOutputStream(file);
                    iRobotItem.storeProperties((OutputStream)fis, props);
                }
                catch (Throwable throwable) {
                    FileUtil.cleanupStream(fis);
                    throw throwable;
                }
                FileUtil.cleanupStream((Object)fis);
            }
            JarCreator.addRobotFilesToJar(target, jarEntries, iRobotItem, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTeamItemToJar(JarOutputStream target, Set<String> jarEntries, TeamItem teamItem, RobotProperties props) throws IOException {
        String robotPathWithoutFileExt = teamItem.getRelativePath() + '/' + teamItem.getShortClassName();
        String fileExt = ".team";
        File file = new File(FileUtil.getRobotsDir(), robotPathWithoutFileExt + fileExt);
        FileOutputStream fis = null;
        try {
            fis = new FileOutputStream(file);
            teamItem.storeProperties(fis, props);
        }
        catch (Throwable throwable) {
            FileUtil.cleanupStream(fis);
            throw throwable;
        }
        FileUtil.cleanupStream((Object)fis);
        JarCreator.addToJar(target, jarEntries, FileUtil.getRobotsDir().getPath(), robotPathWithoutFileExt, fileExt);
    }

    private static void addRobotFilesToJar(JarOutputStream target, Set<String> jarEntries, IRobotItem robotItem, RobotProperties props) throws IOException {
        IHostManager host = (IHostManager)Container.getComponent(IHostManager.class);
        for (String className : host.getReferencedClasses(robotItem)) {
            if (className.startsWith("java") || className.startsWith("robocode")) continue;
            String robotPath = className.replace('.', '/');
            JarCreator.addRobotFilesToJar(target, jarEntries, robotPath, robotItem, props);
        }
    }

    private static void addRobotFilesToJar(JarOutputStream target, Set<String> jarEntries, String robotPathWithoutFileExt, IRobotItem robotItem, RobotProperties props) throws IOException {
        JarCreator.addClassFileToJar(target, jarEntries, robotPathWithoutFileExt, robotItem);
        JarCreator.addPropertiesFileToJar(target, jarEntries, robotPathWithoutFileExt, robotItem);
        JarCreator.addJavaFileToJar(target, jarEntries, robotPathWithoutFileExt, robotItem, props);
        JarCreator.addDataDirToJar(target, jarEntries, robotPathWithoutFileExt, robotItem, props);
    }

    private static void addClassFileToJar(JarOutputStream target, Set<String> jarEntries, String robotPathWithoutFileExt, IRobotItem robotItem) throws IOException {
        String classRootPath = robotItem.getClassPathURL().getPath();
        JarCreator.addToJar(target, jarEntries, classRootPath, robotPathWithoutFileExt, ".class");
    }

    private static void addPropertiesFileToJar(JarOutputStream target, Set<String> jarEntries, String robotPathWithoutFileExt, IRobotItem robotItem) throws IOException {
        String classRootPath = robotItem.getClassPathURL().getPath();
        JarCreator.addToJar(target, jarEntries, classRootPath, robotPathWithoutFileExt, ".properties");
    }

    private static void addJavaFileToJar(JarOutputStream target, Set<String> jarEntries, String robotFilePath, IRobotItem robotItem, RobotProperties props) throws IOException {
        if (props.isIncludeSource() && !robotFilePath.contains("$")) {
            for (URL sourcePathURL : robotItem.getSourcePathURLs()) {
                JarCreator.addToJar(target, jarEntries, sourcePathURL.getPath(), robotFilePath, ".java");
            }
        }
    }

    private static void addDataDirToJar(JarOutputStream target, Set<String> jarEntries, String robotPathWithoutFileExt, IRobotItem robotItem, RobotProperties props) throws IOException {
        if (props.isIncludeData()) {
            String rootPath = robotItem.getRootPath().replace('\\', '/');
            if (rootPath.startsWith("file:/")) {
                rootPath = rootPath.substring("file:/".length());
            }
            JarCreator.addToJar(target, jarEntries, rootPath, robotPathWithoutFileExt, ".data");
        }
    }

    private static void addToJar(JarOutputStream target, Set<String> jarEntries, String rootPath, String robotPathWithoutFileExt, String fileExt) throws IOException {
        String filePath = robotPathWithoutFileExt + fileExt;
        try {
            rootPath = URLDecoder.decode(rootPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError((Throwable)e);
        }
        File file = new File(rootPath, filePath);
        if (file.exists() && !jarEntries.contains(filePath)) {
            JarCreator.addFileToJar(file, filePath, target);
            jarEntries.add(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addFileToJar(File source, String entryPath, JarOutputStream target) throws IOException {
        String path = entryPath.replace("\\", "/");
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (source.isDirectory()) {
            if (!path.isEmpty() && !path.endsWith("/")) {
                path = path + "/";
            }
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File nestedFile = fileArray[n2];
                String newEntryPath = entryPath + '/' + nestedFile.getName();
                JarCreator.addFileToJar(nestedFile, newEntryPath, target);
                ++n2;
            }
            return;
        }
        JarEntry entry = new JarEntry(path);
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            int count;
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis);
            byte[] buffer = new byte[1024];
            while ((count = bis.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            target.closeEntry();
            FileUtil.cleanupStream(bis);
            FileUtil.cleanupStream((Object)fis);
            throw throwable;
        }
        target.closeEntry();
        FileUtil.cleanupStream((Object)bis);
        FileUtil.cleanupStream((Object)fis);
    }

    private static void appendCodeSize(File jarFile, StringBuilder sb) {
        Integer codesize = CodeSizeCalculator.getJarFileCodeSize((File)jarFile);
        if (codesize != null) {
            String weightClass = null;
            weightClass = codesize >= 1500 ? "MegaBot  (codesize >= 1500 bytes)" : (codesize >= 750 ? "MiniBot  (codesize < 1500 bytes)" : (codesize >= 250 ? "MicroBot (codesize < 750 bytes)" : "NanoBot  (codesize < 250 bytes)"));
            sb.append("\n\n---- Codesize ----\n");
            sb.append("Codesize: ").append(codesize).append(" bytes\n");
            sb.append("Robot weight class: ").append(weightClass).append('\n');
        }
    }
}

