/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.parsers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClasspathFileParser {
    private ClasspathHandler classpathHandler = new ClasspathHandler();

    public void parse(URL url) {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(url.toString(), (DefaultHandler)this.classpathHandler);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public String[] getSourcePaths() {
        return this.classpathHandler.sourcePaths.toArray(new String[0]);
    }

    public String getClassPath() {
        return this.classpathHandler.outputPath;
    }

    private static class ClasspathHandler
    extends DefaultHandler {
        String outputPath = null;
        List<String> sourcePaths = new ArrayList<String>();

        private ClasspathHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("classpathentry".equals(qName)) {
                String kind = attributes.getValue("kind");
                if ("src".equals(kind)) {
                    this.sourcePaths.add(attributes.getValue("path"));
                } else if ("output".equals(kind)) {
                    this.outputPath = attributes.getValue("path");
                }
            }
        }
    }
}

