/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.ui.IWindowManager;

public abstract class BaseRoot
implements Serializable,
IRepositoryRoot {
    private static final long serialVersionUID = 1L;
    protected transient IRepository repository;
    protected final File rootPath;
    protected final URL rootURL;

    public BaseRoot(IRepository repository, File rootPath) {
        this.repository = repository;
        this.rootPath = rootPath;
        URL url = null;
        try {
            url = rootPath.toURI().toURL();
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
        this.rootURL = url;
    }

    @Override
    public URL getURL() {
        return this.rootURL;
    }

    @Override
    public File getPath() {
        return this.rootPath;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public String toString() {
        return this.rootURL != null ? this.rootURL.toString() : null;
    }

    @Override
    public void extractJAR() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IRepositoryRoot) {
            return ((IRepositoryRoot)obj).getURL().equals(this.rootURL);
        }
        return false;
    }

    protected static void setStatus(String message) {
        IWindowManager windowManager = (IWindowManager)Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setStatus(message);
        }
    }
}

