/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.host.security.ClassFileReader;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.root.BaseRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.util.UrlUtil;

public final class ClasspathRoot
extends BaseRoot
implements IRepositoryRoot {
    private static final long serialVersionUID = 1L;
    private final File projectPath;

    public ClasspathRoot(IRepository repository, File rootPath, File projectPath) {
        super(repository, rootPath);
        this.projectPath = projectPath;
    }

    @Override
    public void updateItems(boolean force) {
        ClasspathRoot.setStatus("Updating classpath: " + this.rootPath.toString());
        this.repository.removeItemsFromRoot(this);
        ArrayList<IRepositoryItem> items = new ArrayList<IRepositoryItem>();
        ArrayList<Long> itemsLastModification = new ArrayList<Long>();
        ClassAnalyzer.RobotMainClassPredicate mainClassPredicate = ClassFileReader.createMainClassPredicate((URL)this.rootURL);
        this.visitDirectory(this.rootPath.toURI(), this.rootPath, items, itemsLastModification, mainClassPredicate);
        for (int i = 0; i < items.size(); ++i) {
            IRepositoryItem repositoryItem = (IRepositoryItem)items.get(i);
            repositoryItem.update((Long)itemsLastModification.get(i), force);
        }
    }

    private void visitDirectory(final URI rootURI, File path, final List<IRepositoryItem> items, final List<Long> itemsLastModification, final ClassAnalyzer.RobotMainClassPredicate mainClassPredicate) {
        final HashMap map = new HashMap();
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean accept = false;
                if (pathname.isFile()) {
                    String fullName = rootURI.relativize(pathname.toURI()).toString();
                    accept = fullName.toLowerCase().endsWith(".class") ? mainClassPredicate.isMainClassBinary(fullName.substring(0, fullName.length() - 6)) : true;
                }
                if (accept) {
                    ClasspathRoot.this.visitFile(pathname, map, items, itemsLastModification);
                }
                return false;
            }
        });
        File[] subDirs = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().toLowerCase().endsWith(".data") && !pathname.getName().toLowerCase().endsWith(".robotcache");
            }
        });
        if (subDirs != null) {
            for (File subDir : subDirs) {
                this.visitDirectory(rootURI, subDir, items, itemsLastModification, mainClassPredicate);
            }
        }
    }

    private void visitFile(File pathname, HashMap<IRepositoryItem, Integer> map, List<IRepositoryItem> items, List<Long> itemsLastModification) {
        try {
            IRepositoryItem repositoryItem = ItemHandler.registerItem(pathname.toURI().toURL(), this, this.repository);
            if (repositoryItem != null) {
                Integer indice = map.get(repositoryItem);
                long lastModified = pathname.lastModified();
                if (indice == null) {
                    map.put(repositoryItem, itemsLastModification.size());
                    items.add(repositoryItem);
                    itemsLastModification.add(lastModified);
                } else {
                    int index = indice;
                    long v = itemsLastModification.get(index);
                    if (lastModified > v) {
                        itemsLastModification.set(index, lastModified);
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
    }

    @Override
    public void updateItem(IRepositoryItem item, boolean force) {
        ClasspathRoot.setStatus("Updating classpath: " + this.rootPath);
        File file = new File(item.getItemURL().toString());
        item.update(file.lastModified(), force);
    }

    public boolean isChanged(IRepositoryItem repositoryItem) {
        File file = new File(repositoryItem.getItemURL().toString());
        return file.lastModified() > repositoryItem.getLastModified();
    }

    @Override
    public boolean isDevelopmentRoot() {
        return true;
    }

    @Override
    public boolean isJAR() {
        return false;
    }

    public String getFriendlyProjectURL(URL itemURL) {
        String url = null;
        if (this.projectPath != null) {
            try {
                String rootPath = this.projectPath.toURI().toURL().toString();
                String itemPath = itemURL.toString().substring(this.getURL().toString().length());
                url = rootPath + UrlUtil.removeFileExtension((String)itemPath);
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
            }
        }
        return url;
    }
}

