/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.host.security.ClassFileReader;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.items.IRepositoryItem;
import net.sf.robocode.repository.items.RobotItem;
import net.sf.robocode.repository.items.handlers.ItemHandler;
import net.sf.robocode.repository.packager.JarExtractor;
import net.sf.robocode.repository.root.BaseRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;

public final class JarRoot
extends BaseRoot
implements IRepositoryRoot {
    private static final long serialVersionUID = 1L;
    private final String jarPath;
    private final URL jarUrl;
    private long lastModified;

    public JarRoot(IRepository repository, File rootPath) {
        super(repository, rootPath);
        String jarPath = null;
        URL jarUrl = null;
        try {
            jarPath = "jar:" + rootPath.toURI().toString();
            jarUrl = new URL(jarPath + "!/");
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
        this.jarPath = jarPath;
        this.jarUrl = jarUrl;
    }

    @Override
    public void updateItems(boolean force) {
        JarRoot.setStatus("Updating JAR: " + this.rootPath.toString());
        long lastModified = this.rootPath.lastModified();
        if (lastModified > this.lastModified) {
            this.repository.removeItemsFromRoot(this);
            this.lastModified = lastModified;
            LinkedHashSet<IRepositoryItem> repositoryItems = new LinkedHashSet<IRepositoryItem>();
            this.visitItems(repositoryItems);
            for (IRepositoryItem repositoryItem : repositoryItems) {
                repositoryItem.update(lastModified, force);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitItems(Collection<IRepositoryItem> repositoryItems) {
        String root = this.jarPath;
        InputStream is = null;
        BufferedInputStream bis = null;
        JarInputStream jarIS = null;
        try {
            URLConnection con = URLJarCollector.openConnection((URL)this.rootURL);
            is = con.getInputStream();
            bis = new BufferedInputStream(is);
            jarIS = new JarInputStream(bis);
            this.readJarStream(repositoryItems, root, jarIS);
        }
        catch (Exception e) {
            try {
                Logger.logError((String)(this.rootURL + " is probably corrupted (" + e.getClass().getName() + " " + e.getMessage() + ")"));
            }
            catch (Throwable throwable) {
                FileUtil.cleanupStream(jarIS);
                FileUtil.cleanupStream(bis);
                FileUtil.cleanupStream((Object)is);
                throw throwable;
            }
            FileUtil.cleanupStream((Object)jarIS);
            FileUtil.cleanupStream((Object)bis);
            FileUtil.cleanupStream((Object)is);
        }
        FileUtil.cleanupStream((Object)jarIS);
        FileUtil.cleanupStream((Object)bis);
        FileUtil.cleanupStream((Object)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJarStream(Collection<IRepositoryItem> repositoryItems, String root, JarInputStream jarIS) throws IOException {
        URL rootURL = new URL(root + "!/");
        ClassAnalyzer.RobotMainClassPredicate mainClassPredicate = ClassFileReader.createMainClassPredicate((URL)rootURL);
        JarEntry entry = jarIS.getNextJarEntry();
        while (entry != null) {
            String fullName = entry.getName();
            String name = fullName.toLowerCase();
            if (!entry.isDirectory()) {
                if (name.contains(".data/") && !name.contains(".robotcache/")) {
                    JarExtractor.extractFile(FileUtil.getRobotsDataDir(), jarIS, entry);
                } else if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    JarInputStream inner = null;
                    try {
                        inner = new JarInputStream(jarIS);
                        this.readJarStream(repositoryItems, "jar:jar" + root + "^/" + fullName, inner);
                    }
                    finally {
                        if (inner != null) {
                            inner.closeEntry();
                        }
                    }
                } else if (name.endsWith(".class")) {
                    if (mainClassPredicate.isMainClassBinary(fullName.substring(0, fullName.length() - 6))) {
                        this.createItem(repositoryItems, rootURL, entry);
                    }
                } else {
                    this.createItem(repositoryItems, rootURL, entry);
                }
            }
            entry = jarIS.getNextJarEntry();
        }
    }

    private void createItem(Collection<IRepositoryItem> repositoryItems, URL root, JarEntry entry) {
        try {
            String pUrl = root.toString() + entry.getName();
            IRepositoryItem repositoryItem = ItemHandler.registerItem(new URL(pUrl), this, this.repository);
            if (repositoryItem != null) {
                if (repositoryItem instanceof RobotItem) {
                    RobotItem robotItem = (RobotItem)repositoryItem;
                    robotItem.setClassPathURL(root);
                }
                repositoryItems.add(repositoryItem);
            }
        }
        catch (MalformedURLException e) {
            Logger.logError((Throwable)e);
        }
    }

    @Override
    public void updateItem(IRepositoryItem repositoryItem, boolean force) {
        repositoryItem.update(this.rootPath.lastModified(), force);
    }

    public boolean isChanged(IRepositoryItem repositoryItem) {
        return this.rootPath.lastModified() > this.lastModified;
    }

    @Override
    public URL getURL() {
        return this.jarUrl;
    }

    @Override
    public boolean isDevelopmentRoot() {
        return false;
    }

    @Override
    public boolean isJAR() {
        return true;
    }

    @Override
    public void extractJAR() {
        JarExtractor.extractJar(this.rootURL);
    }
}

