/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root.handlers;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.parsers.ClasspathFileParser;
import net.sf.robocode.repository.root.ClasspathRoot;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.repository.root.handlers.RootHandler;

public class ClassPathHandler
extends RootHandler {
    @Override
    public void visitDirectory(File dir, boolean isDevel, Map<String, IRepositoryRoot> newRoots, IRepository repository, boolean force) {
        File classpathFile;
        if (isDevel && (classpathFile = new File(dir, ".classpath")).exists()) {
            ClasspathFileParser classpathParser = new ClasspathFileParser();
            boolean parsed = true;
            try {
                classpathParser.parse(classpathFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                parsed = false;
            }
            if (parsed) {
                String classPath = classpathParser.getClassPath();
                if (classPath != null) {
                    File classPathDir = new File(dir, classPath);
                    this.handleDirectory(classPathDir, dir, newRoots, repository, force);
                }
                for (String sourcePath : classpathParser.getSourcePaths()) {
                    if (sourcePath == null) continue;
                    File sourcePathDir = new File(dir, sourcePath);
                    this.handleDirectory(sourcePathDir, dir, newRoots, repository, force);
                }
                return;
            }
        }
        this.handleDirectory(dir, null, newRoots, repository, force);
    }

    private void handleDirectory(File dir, File projectDir, Map<String, IRepositoryRoot> newRoots, IRepository repository, boolean force) {
        String key;
        try {
            key = dir.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return;
        }
        IRepositoryRoot root = repository.getRoots().get(key);
        if (root == null) {
            root = new ClasspathRoot(repository, dir, projectDir);
        } else {
            repository.removeRoot(key);
        }
        root.updateItems(force);
        newRoots.put(key, root);
    }
}

