/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root.handlers;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.root.IRepositoryRoot;
import net.sf.robocode.repository.root.JarRoot;
import net.sf.robocode.repository.root.handlers.RootHandler;

public class JarHandler
extends RootHandler {
    @Override
    public void visitDirectory(File dir, boolean isDevel, Map<String, IRepositoryRoot> newRoots, IRepository repository, boolean force) {
        if (!isDevel) {
            File[] jars = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String path = pathname.toString().toLowerCase();
                    return pathname.isFile() && (path.endsWith(".jar") || path.endsWith(".zip"));
                }
            });
            if (jars == null) {
                return;
            }
            for (File jar : jars) {
                String key;
                try {
                    key = "jar:" + jar.toURI().toURL().toString() + "!/";
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    continue;
                }
                IRepositoryRoot root = repository.getRoots().get(key);
                if (root == null) {
                    root = new JarRoot(repository, jar);
                } else {
                    repository.removeRoot(key);
                }
                root.updateItems(force);
                newRoots.put(key, root);
                try {
                    URLJarCollector.closeJarURLConnection((URL)jar.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    Logger.logError((Throwable)e);
                }
                URLJarCollector.gc();
            }
        }
    }
}

