/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository.root.handlers;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.sf.robocode.core.Container;
import net.sf.robocode.repository.IRepository;
import net.sf.robocode.repository.root.IRepositoryRoot;

public abstract class RootHandler {
    public abstract void visitDirectory(File var1, boolean var2, Map<String, IRepositoryRoot> var3, IRepository var4, boolean var5);

    public void open() {
    }

    public void close() {
    }

    public static void visitDirectories(File dir, boolean isDevel, Map<String, IRepositoryRoot> newRoots, IRepository repository, boolean force) {
        List itemHandlerList = Container.getComponents(RootHandler.class);
        for (RootHandler handler : itemHandlerList) {
            handler.visitDirectory(dir, isDevel, newRoots, repository, force);
        }
    }

    public static void openHandlers() {
        List rootHandlers = Container.getComponents(RootHandler.class);
        for (RootHandler handler : rootHandlers) {
            handler.open();
        }
    }

    public static void closeHandlers() {
        List rootHandlers = Container.getComponents(RootHandler.class);
        for (RootHandler handler : rootHandlers) {
            handler.close();
        }
    }
}

