/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;

public class BrowserManager {
    public static void openURL(String url) throws IOException {
        Desktop desktop;
        url = url.replace('\\', '/');
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
                return;
            }
            catch (URISyntaxException e) {
                Logger.logError((Throwable)e);
            }
        }
        url = FileUtil.quoteFileName((String)url);
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            rt.exec("rundll32 url.dll, FileProtocolHandler " + url);
        } else if (os.startsWith("mac")) {
            rt.exec("open " + url);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "galeon", "netscape", "opera", "links", "lynx"};
            StringBuffer cmd = new StringBuffer();
            for (int i = 0; i < browsers.length; ++i) {
                cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
            }
            rt.exec(new String[]{"sh", "-c", cmd.toString()});
        }
    }
}

