/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.IImageManager;
import net.sf.robocode.ui.gfx.ImageUtil;
import net.sf.robocode.ui.gfx.RenderImage;

public class ImageManager
implements IImageManager {
    private final ISettingsManager properties;
    private Image[] groundImages;
    private RenderImage[][] explosionRenderImages;
    private RenderImage debriseRenderImage;
    private Image bodyImage;
    private Image gunImage;
    private Image radarImage;
    private static final int MAX_NUM_COLORS = 256;
    private HashMap<Integer, RenderImage> robotBodyImageCache;
    private HashMap<Integer, RenderImage> robotGunImageCache;
    private HashMap<Integer, RenderImage> robotRadarImageCache;

    public ImageManager(ISettingsManager properties) {
        this.properties = properties;
    }

    @Override
    public void initialize() {
        this.groundImages = new Image[5];
        this.explosionRenderImages = null;
        this.debriseRenderImage = null;
        this.bodyImage = null;
        this.gunImage = null;
        this.radarImage = null;
        this.robotBodyImageCache = new RenderCache<Integer, RenderImage>();
        this.robotGunImageCache = new RenderCache<Integer, RenderImage>();
        this.robotRadarImageCache = new RenderCache<Integer, RenderImage>();
        this.getBodyImage();
        this.getGunImage();
        this.getRadarImage();
        this.getExplosionRenderImage(0, 0);
    }

    @Override
    public Image getGroundTileImage(int index) {
        if (this.groundImages[index] == null) {
            this.groundImages[index] = this.getImage("/net/sf/robocode/ui/images/ground/blue_metal/blue_metal_" + index + ".png");
        }
        return this.groundImages[index];
    }

    @Override
    public RenderImage getExplosionRenderImage(int which, int frame) {
        if (this.explosionRenderImages == null) {
            ArrayList explosions = new ArrayList();
            boolean done = false;
            int numExplosion = 1;
            while (!done) {
                ArrayList<RenderImage> frames = new ArrayList<RenderImage>();
                int numFrame = 1;
                while (true) {
                    String filename;
                    if (ImageManager.class.getResource(filename = "/net/sf/robocode/ui/images/explosion/explosion" + numExplosion + '-' + numFrame + ".png") == null) {
                        if (numFrame == 1) {
                            done = true;
                            break;
                        }
                        explosions.add(frames);
                        break;
                    }
                    frames.add(new RenderImage(this.getImage(filename)));
                    ++numFrame;
                }
                ++numExplosion;
            }
            numExplosion = explosions.size();
            this.explosionRenderImages = new RenderImage[numExplosion][];
            for (int i = numExplosion - 1; i >= 0; --i) {
                this.explosionRenderImages[i] = ((List)explosions.get(i)).toArray(new RenderImage[explosions.size()]);
            }
        }
        return this.explosionRenderImages[which][frame];
    }

    @Override
    public RenderImage getExplosionDebriseRenderImage() {
        if (this.debriseRenderImage == null) {
            this.debriseRenderImage = new RenderImage(this.getImage("/net/sf/robocode/ui/images/ground/explode_debris.png"));
        }
        return this.debriseRenderImage;
    }

    private Image getImage(String filename) {
        Image image = ImageUtil.getImage(filename);
        if (this.properties.getOptionsRenderingBufferImages()) {
            image = ImageUtil.getBufferedImage(image);
        }
        return image;
    }

    private Image getBodyImage() {
        if (this.bodyImage == null) {
            this.bodyImage = this.getImage("/net/sf/robocode/ui/images/body.png");
        }
        return this.bodyImage;
    }

    private Image getGunImage() {
        if (this.gunImage == null) {
            this.gunImage = this.getImage("/net/sf/robocode/ui/images/turret.png");
        }
        return this.gunImage;
    }

    private Image getRadarImage() {
        if (this.radarImage == null) {
            this.radarImage = this.getImage("/net/sf/robocode/ui/images/radar.png");
        }
        return this.radarImage;
    }

    @Override
    public RenderImage getColoredBodyRenderImage(Integer color) {
        RenderImage img = this.robotBodyImageCache.get(color);
        if (img == null) {
            img = new RenderImage(ImageUtil.createColouredRobotImage(this.getBodyImage(), new Color(color, true)));
            this.robotBodyImageCache.put(color, img);
        }
        return img;
    }

    @Override
    public RenderImage getColoredGunRenderImage(Integer color) {
        RenderImage img = this.robotGunImageCache.get(color);
        if (img == null) {
            img = new RenderImage(ImageUtil.createColouredRobotImage(this.getGunImage(), new Color(color, true)));
            this.robotGunImageCache.put(color, img);
        }
        return img;
    }

    @Override
    public RenderImage getColoredRadarRenderImage(Integer color) {
        RenderImage img = this.robotRadarImageCache.get(color);
        if (img == null) {
            img = new RenderImage(ImageUtil.createColouredRobotImage(this.getRadarImage(), new Color(color, true)));
            this.robotRadarImageCache.put(color, img);
        }
        return img;
    }

    private static class RenderCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int INITIAL_CAPACITY = 257;
        private static final float LOAD_FACTOR = 1.0f;

        public RenderCache() {
            super(257, 1.0f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 256;
        }
    }
}

