/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.robocode.ui.BrowserManager;
import net.sf.robocode.ui.dialog.RobocodeFrame;
import net.sf.robocode.version.IVersionManager;

public final class AboutBox
extends JDialog {
    private static final Color BG_COLOR = new Color(240, 240, 240);
    private static final String TAG_ROBOCODE_VERSION = "\\Q{$robocode-version}\\E";
    private static final String TAG_ROBOCODE_ICON_SRC = "\\Q{$robocode-icon-url}\\E";
    private static final String TAG_BG_COLOR = "\\Q{$background-color}\\E";
    private static final String TAG_JAVA_VERSION = "\\Q{$java-version}\\E";
    private static final String TAG_JAVA_VENDOR = "\\Q{$java-vendor}\\E";
    private static final String TAG_TRANSPARENT = "\\Q{$transparent}\\E";
    private final String robocodeVersion;
    private final URL iconURL;
    private final URL transparentURL;
    private JPanel aboutBoxContentPane;
    private JEditorPane mainPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private String html;
    private final transient ActionListener eventHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AboutBox.this.getOkButton()) {
                AboutBox.this.dispose();
            }
        }
    };
    private final transient HyperlinkListener hyperlinkHandler = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    BrowserManager.openURL(event.getURL().toExternalForm());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    private static String getHtmlTemplate() {
        URL url = AboutBox.class.getResource("/net/sf/robocode/ui/html/about.html");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            URLConnection connection = url.openConnection();
            int contentLength = connection.getContentLength();
            InputStream in = url.openStream();
            byte[] buf = new byte[contentLength];
            while ((len = in.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toString();
    }

    public AboutBox(RobocodeFrame owner, IVersionManager versionManager) {
        super((Frame)owner, true);
        this.robocodeVersion = versionManager.getVersion();
        this.iconURL = AboutBox.class.getResource("/net/sf/robocode/ui/icons/robocode-icon.png");
        this.transparentURL = AboutBox.class.getResource("/net/sf/robocode/ui/html/transparent.png");
        this.setDefaultCloseOperation(2);
        this.setTitle("About Robocode");
        this.setContentPane(this.getAboutBoxContentPane());
        this.setResizable(false);
    }

    private JPanel getAboutBoxContentPane() {
        if (this.aboutBoxContentPane == null) {
            this.aboutBoxContentPane = new JPanel();
            this.aboutBoxContentPane.setLayout(new BorderLayout());
            this.aboutBoxContentPane.add((Component)this.getButtonPanel(), "South");
            this.aboutBoxContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.aboutBoxContentPane;
    }

    private JEditorPane getMainPanel() {
        if (this.mainPanel == null) {
            String aaFontSettings = System.getProperty("awt.useSystemAAFontSettings");
            if (aaFontSettings != null) {
                this.mainPanel = new JEditorPane("text/html; charset=ISO-8859-1", this.getHtmlText());
                System.out.println(aaFontSettings);
            } else {
                this.mainPanel = new JEditorPane("text/html; charset=ISO-8859-1", this.getHtmlText()){

                    @Override
                    public void paintComponent(Graphics g) {
                        Graphics2D g2 = (Graphics2D)g;
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        super.paintComponent(g);
                    }
                };
            }
            this.mainPanel.setBackground(BG_COLOR);
            this.mainPanel.setEditable(false);
            this.mainPanel.addHyperlinkListener(this.hyperlinkHandler);
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBackground(BG_COLOR);
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add(this.getOkButton());
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(this.eventHandler);
        }
        return this.okButton;
    }

    private String getHtmlText() {
        if (this.html == null) {
            this.html = AboutBox.getHtmlTemplate();
            this.html = this.html.replaceAll(TAG_ROBOCODE_VERSION, this.robocodeVersion);
            this.html = this.html.replaceAll(TAG_ROBOCODE_ICON_SRC, this.iconURL.toString());
            this.html = this.html.replaceAll(TAG_BG_COLOR, AboutBox.toHtmlColor(BG_COLOR));
            this.html = this.html.replaceAll(TAG_JAVA_VERSION, AboutBox.getJavaVersion());
            this.html = this.html.replaceAll(TAG_JAVA_VENDOR, System.getProperty("java.vendor"));
            this.html = this.html.replaceAll(TAG_TRANSPARENT, this.transparentURL.toString());
        }
        return this.html;
    }

    private static String toHtmlColor(Color color) {
        return "#" + AboutBox.toHexDigits(color.getRed()) + AboutBox.toHexDigits(color.getGreen()) + AboutBox.toHexDigits(color.getBlue());
    }

    private static String toHexDigits(int value) {
        return "" + AboutBox.toHexDigit(value >> 4) + AboutBox.toHexDigit(value & 0xF);
    }

    private static char toHexDigit(int value) {
        int v = value & 0xF;
        if (v < 10) {
            return (char)(48 + v);
        }
        return (char)(65 + (v - 10));
    }

    private static String getJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        String javaArchModel = System.getProperty("sun.arch.data.model");
        if (javaArchModel != null) {
            try {
                int numBits = Integer.parseInt(javaArchModel);
                javaVersion = javaVersion + " (" + numBits + "-bit)";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return javaVersion;
    }
}

