/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.robocode.ui.dialog.ConsoleTableModel;

public final class ConsoleScrollPane
extends JScrollPane {
    private final ArrayList<String> lines = new ArrayList();
    private JTable table = null;

    public ConsoleScrollPane() {
        this.setViewportView(this.getTextPane());
    }

    public JTable getTextPane() {
        if (this.table == null) {
            this.table = new JTable(){

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return this.hasExcessWidth();
                }

                @Override
                public void doLayout() {
                    if (this.hasExcessWidth()) {
                        this.autoResizeMode = 4;
                    }
                    super.doLayout();
                    this.autoResizeMode = 0;
                }

                protected boolean hasExcessWidth() {
                    return this.getPreferredSize().width < ConsoleScrollPane.this.getViewport().getWidth();
                }
            };
            this.table.setTableHeader(null);
            this.table.setFillsViewportHeight(true);
            this.table.setModel(new ConsoleTableModel(this.lines));
            this.resetWidth();
            this.getViewport().setBackground(Color.DARK_GRAY);
            this.table.setBackground(Color.DARK_GRAY);
            this.table.setGridColor(Color.DARK_GRAY);
            this.table.setShowGrid(false);
            this.table.setForeground(Color.WHITE);
            this.table.setFont(new Font("Monospaced", 0, 12));
        }
        return this.table;
    }

    private void fitTextWidth(int low, int high) {
        JTable table = this.getTextPane();
        TableColumn col = table.getColumnModel().getColumn(0);
        int width = col.getMinWidth() - 2;
        for (int r = low; r <= high; ++r) {
            TableCellRenderer renderer = table.getCellRenderer(r, 0);
            Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, 0), false, false, r, 0);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setMinWidth(width + 2);
    }

    public void append(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        int n = this.lines.size();
        String[] t = str.split("\\n", -1);
        if (this.lines.isEmpty()) {
            this.lines.addAll(Arrays.asList(t));
        } else {
            int last = n - 1;
            String lastLine = this.lines.get(last);
            assert (t.length > 0);
            if (lastLine.length() > 0) {
                this.lines.set(last, lastLine + t[0]);
            } else {
                this.lines.set(last, t[0]);
            }
            this.lines.addAll(Arrays.asList(t).subList(1, t.length));
        }
        AbstractTableModel model = (AbstractTableModel)this.getTextPane().getModel();
        if (n > 0) {
            model.fireTableRowsUpdated(n - 1, n - 1);
        }
        model.fireTableRowsInserted(n, this.lines.size() - 1);
        this.fitTextWidth(Math.max(0, n - 1), this.lines.size() - 1);
    }

    public String getSelectedText() {
        JTable table = this.getTextPane();
        int[] rows = table.getSelectedRows();
        StringBuilder sb = new StringBuilder();
        for (int i : rows) {
            sb.append(this.lines.get(i));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.lines) {
            sb.append(line);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void setText(String t) {
        this.resetWidth();
        this.lines.clear();
        this.lines.trimToSize();
        if (t != null && t.length() != 0) {
            this.lines.addAll(Arrays.asList(t.split("\\n", -1)));
        }
        ((AbstractTableModel)this.getTextPane().getModel()).fireTableDataChanged();
        if (!this.lines.isEmpty()) {
            this.fitTextWidth(0, this.lines.size() - 1);
        }
    }

    private void resetWidth() {
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMinWidth(0);
        col.setPreferredWidth(0);
    }

    public void processStream(InputStream input) {
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                this.append(line + "\n");
            }
        }
        catch (IOException e) {
            this.append("SYSTEM: IOException: " + e);
        }
        this.scrollToBottom();
    }

    public void scrollToBottom() {
        final JTable table = this.getTextPane();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 0, true));
            }
        });
    }
}

