/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.ui.CheckList;
import net.sf.robocode.ui.dialog.WizardPanel;

public class PreferencesDevelopmentOptionsTab
extends WizardPanel {
    private JPanel optionsPanel;
    private JButton addButton;
    private JButton removeButton;
    private CheckList pathList;
    public final ISettingsManager properties;
    private final EventHandler eventHandler = new EventHandler();

    public PreferencesDevelopmentOptionsTab(ISettingsManager properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getOptionsPanel());
        this.loadPreferences(this.properties);
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Development"));
            GridBagLayout layout = new GridBagLayout();
            this.optionsPanel.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 5, 5);
            c.anchor = 18;
            c.fill = 2;
            c.gridwidth = 2;
            c.weightx = 0.0;
            c.gridy = 1;
            this.optionsPanel.add((Component)new JLabel("If you are using an external IDE to develop robots, you may enter the classpath(s) to those robots here."), c);
            ++c.gridy;
            this.optionsPanel.add((Component)new JLabel("If you are using Eclipse, you can enter the root dir of robot projects inside a workspace as well (recommended)"), c);
            ++c.gridy;
            this.optionsPanel.add((Component)new JLabel("Double-click the path(s) the enable or disable it (checked means enabled)"), c);
            c.gridwidth = 1;
            ++c.gridy;
            c.insets = new Insets(3, 3, 3, 3);
            this.optionsPanel.add((Component)this.getAddButton(), c);
            ++c.gridy;
            this.optionsPanel.add((Component)this.getRemoveButton(), c);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 1;
            --c.gridy;
            c.gridheight = 3;
            c.insets = new Insets(5, 5, 5, 5);
            JScrollPane pathListScroller = new JScrollPane(this.getPathList());
            this.optionsPanel.add((Component)pathListScroller, c);
        }
        return this.optionsPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton("Add");
            this.addButton.setDisplayedMnemonicIndex(2);
            this.addButton.addActionListener(this.eventHandler);
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton("Remove");
            this.removeButton.setDisplayedMnemonicIndex(3);
            this.removeButton.addActionListener(this.eventHandler);
        }
        return this.removeButton;
    }

    private CheckList getPathList() {
        if (this.pathList == null) {
            this.pathList = new CheckList();
            this.pathList.setSelectionMode(2);
            this.pathList.setLayoutOrientation(0);
            this.pathList.setVisibleRowCount(-1);
            this.pathList.addListSelectionListener(this.eventHandler);
        }
        return this.pathList;
    }

    private void loadPreferences(ISettingsManager robocodeProperties) {
        this.getPathList().clear();
        for (String path : robocodeProperties.getOptionsDevelopmentPaths()) {
            this.getPathList().add(path);
        }
        for (String excludedPath : robocodeProperties.getOptionsExcludedDevelopmentPaths()) {
            this.getPathList().setChecked(excludedPath, false);
        }
        this.updateRemoveButton();
    }

    public void storePreferences() {
        this.properties.setOptionsDevelopmentPaths(this.getPathList().getAll());
        this.properties.setOptionsExcludedDevelopmentPaths(this.getPathList().getUnchecked());
        this.properties.saveProperties();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void handleAddAction() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this.optionsPanel) == 0) {
            String path = chooser.getSelectedFile().getAbsolutePath();
            if (!this.getPathList().contains(path)) {
                this.getPathList().add(path);
                this.getPathList().sort();
            }
        }
        this.updateRemoveButton();
    }

    private void handleRemoveAction() {
        int[] indices = this.getPathList().getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.getPathList().remove(indices[i]);
        }
        this.updateRemoveButton();
    }

    private void updateRemoveButton() {
        this.getRemoveButton().setEnabled(this.getPathList().getSelectedIndex() >= 0);
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PreferencesDevelopmentOptionsTab.this.getAddButton()) {
                PreferencesDevelopmentOptionsTab.this.handleAddAction();
            } else if (e.getSource() == PreferencesDevelopmentOptionsTab.this.getRemoveButton()) {
                PreferencesDevelopmentOptionsTab.this.handleRemoveAction();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PreferencesDevelopmentOptionsTab.this.updateRemoveButton();
        }
    }
}

