/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.repository.TeamProperties;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.ui.dialog.RobotSelectionPanel;
import net.sf.robocode.ui.dialog.TeamCreatorOptionsPanel;
import net.sf.robocode.ui.dialog.WizardCardPanel;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.util.ShortcutUtil;

public class TeamCreator
extends JDialog
implements WizardListener {
    private JPanel teamCreatorContentPane;
    private WizardCardPanel wizardPanel;
    private WizardController wizardController;
    private RobotSelectionPanel robotSelectionPanel;
    private TeamCreatorOptionsPanel teamCreatorOptionsPanel;
    private final int minRobots = 2;
    private final int maxRobots = 10;
    private final EventHandler eventHandler = new EventHandler();
    private final IRepositoryManager repositoryManager;

    public TeamCreator(IWindowManager windowManager, IRepositoryManager repositoryManager) {
        super(windowManager.getRobocodeFrame());
        this.repositoryManager = repositoryManager;
        this.initialize();
    }

    protected TeamCreatorOptionsPanel getTeamCreatorOptionsPanel() {
        if (this.teamCreatorOptionsPanel == null) {
            this.teamCreatorOptionsPanel = new TeamCreatorOptionsPanel(this);
        }
        return this.teamCreatorOptionsPanel;
    }

    private JPanel getTeamCreatorContentPane() {
        if (this.teamCreatorContentPane == null) {
            this.teamCreatorContentPane = new JPanel();
            this.teamCreatorContentPane.setLayout(new BorderLayout());
            this.teamCreatorContentPane.add((Component)this.getWizardController(), "South");
            this.teamCreatorContentPane.add((Component)this.getWizardPanel(), "Center");
            this.getWizardPanel().getWizardController().setFinishButtonTextAndMnemonic("Create Team!", 'C', 0);
            this.teamCreatorContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 1);
            this.teamCreatorContentPane.registerKeyboardAction(this.eventHandler, "Refresh", KeyStroke.getKeyStroke(82, ShortcutUtil.MENU_SHORTCUT_KEY_MASK), 0);
        }
        return this.teamCreatorContentPane;
    }

    protected RobotSelectionPanel getRobotSelectionPanel() {
        if (this.robotSelectionPanel == null) {
            this.robotSelectionPanel = (RobotSelectionPanel)Container.createComponent(RobotSelectionPanel.class);
            this.robotSelectionPanel.setup(2, 10, false, "Select the robots for this team.", false, true, true, false, false, false, null);
        }
        return this.robotSelectionPanel;
    }

    private WizardCardPanel getWizardPanel() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new WizardCardPanel(this);
            this.wizardPanel.add((Component)this.getRobotSelectionPanel(), "Select robots");
            this.wizardPanel.add((Component)this.getTeamCreatorOptionsPanel(), "Select options");
        }
        return this.wizardPanel;
    }

    public void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Create a team");
        this.setContentPane(this.getTeamCreatorContentPane());
    }

    private WizardController getWizardController() {
        if (this.wizardController == null) {
            this.wizardController = this.getWizardPanel().getWizardController();
        }
        return this.wizardController;
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.dispose();
    }

    @Override
    public void finishButtonActionPerformed() {
        try {
            int rc = this.createTeam();
            if (rc == 0) {
                JOptionPane.showMessageDialog(this, "Team created successfully.", "Success", 1, null);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Team creation cancelled", "Cancelled", 1, null);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Team Creation Failed", 0, null);
        }
    }

    public int createTeam() throws IOException {
        int ok;
        File file = new File(this.repositoryManager.getRobotsDirectory(), this.teamCreatorOptionsPanel.getTeamPackage().replace('.', File.separatorChar) + this.teamCreatorOptionsPanel.getTeamNameField().getText() + ".team");
        if (file.exists() && ((ok = JOptionPane.showConfirmDialog(this, file + " already exists.  Are you sure you want to replace it?", "Warning", 1)) == 1 || ok == 2)) {
            return -1;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            Logger.logError((String)("Can't create " + file.getParentFile().toString()));
        }
        URL webPageUrl = null;
        String webPageFieldString = this.teamCreatorOptionsPanel.getWebpageField().getText();
        if (webPageFieldString != null && webPageFieldString.length() > 0) {
            try {
                webPageUrl = new URL(webPageFieldString);
            }
            catch (MalformedURLException e) {
                try {
                    webPageUrl = new URL("http://" + webPageFieldString);
                    this.teamCreatorOptionsPanel.getWebpageField().setText(webPageUrl.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        String members = this.robotSelectionPanel.getSelectedRobotsAsString();
        String version = this.teamCreatorOptionsPanel.getVersionField().getText();
        String author = this.teamCreatorOptionsPanel.getAuthorField().getText();
        String desc = this.teamCreatorOptionsPanel.getDescriptionArea().getText();
        TeamProperties props = new TeamProperties();
        props.setMembers(members);
        props.setVersion(version);
        props.setAuthor(author);
        props.setDescription(desc);
        props.setWebPage(webPageUrl);
        this.repositoryManager.createTeam(file, props);
        return 0;
    }

    class EventHandler
    implements ActionListener {
        EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Refresh")) {
                TeamCreator.this.getRobotSelectionPanel().refreshRobotList(true);
            }
        }
    }
}

