/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.robocode.ui.dialog.WindowPositionManager;

public class WindowUtil {
    private static final Point origin = new Point(0, 0);
    private static final WindowPositionManager windowPositionManager = new WindowPositionManager();
    private static JLabel statusLabel;
    private static PrintWriter statusWriter;
    private static JLabel defaultStatusLabel;

    public static void center(Window w) {
        WindowUtil.center(null, w);
    }

    public static void center(Window main, Window w) {
        WindowUtil.center(main, w, true);
    }

    public static void center(Window main, Window w, boolean move) {
        Point location = null;
        Dimension size = null;
        Rectangle windowRect = windowPositionManager.getWindowRect(w);
        if (windowRect != null) {
            location = new Point(windowRect.x, windowRect.y);
            size = new Dimension(windowRect.width, windowRect.height);
        }
        if (!move) {
            size = null;
        }
        if (location == null || size == null) {
            Dimension screenSize = main != null ? main.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
            size = w.getSize();
            if (size.height > screenSize.height - 20 || size.width > screenSize.width - 20) {
                if (w.getName().equals("RobocodeFrame")) {
                    int shrink = size.width - screenSize.width + 20;
                    if (size.height - screenSize.height + 20 > shrink) {
                        shrink = size.height - screenSize.height + 20;
                    }
                    size.width -= shrink;
                    size.height -= shrink;
                } else {
                    if (size.height > screenSize.height - 20) {
                        size.height = screenSize.height - 20;
                    }
                    if (size.width > screenSize.width - 20) {
                        size.width = screenSize.width - 20;
                    }
                }
            }
            if (main != null) {
                location = main.getLocation();
                location.x += (screenSize.width - size.width) / 2;
                location.y += (screenSize.height - size.height) / 2;
            } else {
                location = new Point((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
            }
        }
        w.setSize(size);
        if (move) {
            w.setLocation(location);
        }
    }

    public static void centerShow(Window main, Window window) {
        WindowUtil.center(main, window);
        window.setVisible(true);
    }

    public static void setFixedSize(JComponent component, Dimension size) {
        component.setPreferredSize(size);
        component.setMinimumSize(size);
        component.setMaximumSize(size);
    }

    public static void error(JFrame frame, String msg) {
        Object[] options = new Object[]{"OK"};
        JOptionPane.showOptionDialog(frame, msg, "Error", -1, 0, null, options, options[0]);
    }

    public static void fitWindow(Window w) {
        w.pack();
        WindowUtil.center(null, w, false);
    }

    public static void packCenterShow(Window window) {
        window.removeComponentListener(windowPositionManager);
        window.pack();
        WindowUtil.center(window);
        window.setVisible(true);
    }

    public static void packCenterShow(Window main, Window window) {
        window.removeComponentListener(windowPositionManager);
        window.pack();
        WindowUtil.center(main, window);
        window.setVisible(true);
    }

    public static void packPlaceShow(Window window) {
        window.pack();
        WindowUtil.place(window);
        window.setVisible(true);
    }

    public static void place(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = w.getSize();
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        w.setLocation(origin);
        WindowUtil.origin.y += 150;
        if (WindowUtil.origin.y + size.height > screenSize.height) {
            WindowUtil.origin.y = 0;
            WindowUtil.origin.x += 40;
        }
        if (WindowUtil.origin.x + size.width > screenSize.width) {
            WindowUtil.origin.x = 0;
        }
    }

    public static void saveWindowPositions() {
        windowPositionManager.saveWindowPositions();
    }

    public static void message(String s) {
        JOptionPane.showMessageDialog(null, s, "Message", 1);
    }

    public static void messageWarning(String s) {
        JOptionPane.showMessageDialog(null, s, "Warning", 2);
    }

    public static void messageError(String s) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(null, s, "Message", 0);
    }

    public static void setStatus(String s) {
        if (statusWriter != null) {
            statusWriter.println(s);
        }
        if (statusLabel != null) {
            statusLabel.setText(s);
        } else if (defaultStatusLabel != null) {
            defaultStatusLabel.setText(s);
        }
    }

    public static void setStatusLabel(JLabel label) {
        statusLabel = label;
    }

    public static void setDefaultStatusLabel(JLabel label) {
        defaultStatusLabel = label;
    }

    public static void setStatusWriter(PrintWriter out) {
        statusWriter = out;
    }
}

