/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.dialog;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import net.sf.robocode.ui.dialog.Wizard;
import net.sf.robocode.ui.dialog.WizardController;
import net.sf.robocode.ui.dialog.WizardListener;
import net.sf.robocode.ui.dialog.WizardPanel;

public class WizardCardPanel
extends JPanel
implements Wizard {
    private WizardController wizardController;
    private CardLayout cardLayout = null;
    private int currentIndex = 0;
    private final WizardListener listener;
    private final EventHandler eventHandler = new EventHandler();

    public WizardCardPanel(WizardListener listener) {
        this.listener = listener;
        this.initialize();
    }

    @Override
    public void back() {
        --this.currentIndex;
        this.getWizardController().stateChanged(null);
        this.getCardLayout().previous(this);
    }

    public CardLayout getCardLayout() {
        if (this.cardLayout == null) {
            this.cardLayout = new CardLayout();
        }
        return this.cardLayout;
    }

    @Override
    public Component getCurrentPanel() {
        return this.getComponent(this.currentIndex);
    }

    @Override
    public WizardController getWizardController() {
        if (this.wizardController == null) {
            this.wizardController = new WizardController(this);
        }
        return this.wizardController;
    }

    @Override
    public WizardListener getWizardListener() {
        return this.listener;
    }

    public void initialize() {
        this.setLayout(this.getCardLayout());
        this.addContainerListener(this.eventHandler);
    }

    @Override
    public boolean isBackAvailable() {
        return this.currentIndex > 0;
    }

    public boolean isCurrentPanelReady() {
        Component c = this.getCurrentPanel();
        return !(c instanceof WizardPanel) || ((WizardPanel)c).isReady();
    }

    @Override
    public boolean isNextAvailable() {
        return this.currentIndex < this.getComponentCount() - 1 && this.isCurrentPanelReady();
    }

    @Override
    public boolean isReady() {
        for (Component c : this.getComponents()) {
            if (((WizardPanel)c).isReady()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void next() {
        ++this.currentIndex;
        this.getWizardController().stateChanged(null);
        this.getCardLayout().next(this);
    }

    @Override
    public void setWizardControllerOnPanel(WizardPanel panel) {
        panel.setWizardController(this.getWizardController());
    }

    public class EventHandler
    implements ContainerListener {
        @Override
        public void componentRemoved(ContainerEvent e) {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof WizardPanel) {
                WizardCardPanel.this.setWizardControllerOnPanel((WizardPanel)e.getChild());
                WizardCardPanel.this.getWizardController().stateChanged(new ChangeEvent(e.getChild()));
            }
        }
    }
}

