/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.gfx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import net.sf.robocode.ui.gfx.ImageUtil;
import net.sf.robocode.ui.gfx.RenderImage;

public class RobocodeLogo {
    public static final int WIDTH = 570;
    public static final int HEIGHT = 213;
    private static final Color WHITE_ALPHA_7F = new Color(255, 255, 255, 127);
    private static final Color GLOW_GREEN = new Color(10, 255, 10, 102);
    private static final Color DARK_GREEN_ALPHA_80 = new Color(0, 112, 0, 128);
    private static final Color GREEN_ALPHA_08 = new Color(0, 255, 0, 8);
    private static final Color GREEN_ALPHA_20 = new Color(0, 255, 0, 32);
    private static final Color GREEN_ALPHA_40 = new Color(0, 255, 0, 64);
    private static final Color GREEN_ALPHA_48 = new Color(0, 255, 0, 72);
    private static final Color GREEN_ALPHA_80 = new Color(0, 255, 0, 128);
    private static final Shape I_SHAPE = new Rectangle2D.Float(0.0f, 0.0f, 13.0f, 46.0f);
    private static final Stroke THIN_STROKE = new BasicStroke(1.5f);
    private Area outerDecoration;
    private Area middleDecoration;
    private Area innerSubDecoration;
    private Area innerDecoration;
    private GeneralPath robocodeTextPath;

    public void paintLogoWithTanks(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        AffineTransform origTransform = g.getTransform();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 570, 213);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.drawTanks(g);
        this.drawOuterDecoration(g);
        this.drawMiddleEllipse(g);
        this.drawMiddleDecoration(g);
        this.drawInnerDecoration(g);
        this.drawInnerSubDecoration(g);
        this.drawRobocodeText(g);
        g.setTransform(origTransform);
    }

    private void transform(Graphics2D g, AffineTransform tx) {
        AffineTransform at = new AffineTransform();
        if (tx != null) {
            at.concatenate(tx);
        }
        g.setTransform(at);
    }

    private void drawTanks(Graphics2D g) {
        AffineTransform origTransform = g.getTransform();
        this.drawRobot(g, 22, 192, 1.5707964f, -0.2f, -0.2f, new Color(48, 0, 16, 255));
        this.drawRobot(g, 22, 92, 1.5707964f, (float)Math.PI, (float)Math.PI, new Color(22, 0, 44, 255));
        this.drawRobot(g, 212, 173, 0.75f, 0.75f, 0.75f, new Color(2, 1, 0, 255));
        this.drawRobot(g, 455, 50, 2.4f, 2.0f, 2.0f, new Color(2, 0, 1, 255));
        this.drawRobot(g, 492, 82, -0.3f, -0.27f, -0.27f, new Color(0, 0, 1, 255));
        this.transform(g, AffineTransform.getTranslateInstance(270.0, -25.0));
        RenderImage explRenderImage1 = new RenderImage(ImageUtil.getImage("/net/sf/robocode/ui/images/explosion/explosion2-24.png"));
        explRenderImage1.paint(g);
        this.transform(g, AffineTransform.getTranslateInstance(23.0, 102.0));
        RenderImage explRenderImage2 = new RenderImage(ImageUtil.getImage("/net/sf/robocode/ui/images/explosion/explosion1-8.png"));
        explRenderImage2.setTransform(AffineTransform.getScaleInstance(0.3, 0.3));
        explRenderImage2.paint(g);
        this.transform(g, AffineTransform.getTranslateInstance(464.0, 55.0));
        RenderImage explRenderImage3 = new RenderImage(ImageUtil.getImage("/net/sf/robocode/ui/images/explosion/explosion1-1.png"));
        explRenderImage3.setTransform(AffineTransform.getScaleInstance(0.5, 0.5));
        explRenderImage3.paint(g);
        this.transform(g, AffineTransform.getTranslateInstance(488.0, 72.0));
        RenderImage explRenderImage4 = new RenderImage(ImageUtil.getImage("/net/sf/robocode/ui/images/explosion/explosion1-6.png"));
        explRenderImage4.setTransform(AffineTransform.getScaleInstance(0.4, 0.4));
        explRenderImage4.paint(g);
        this.transform(g, origTransform);
        g.setColor(Color.LIGHT_GRAY);
        g.fillOval(20, 154, 3, 3);
    }

    private void drawRobot(Graphics2D g, int x, int y, float bodyAngle, float gunAngle, float radarAngle, Color color) {
        this.transform(g, AffineTransform.getTranslateInstance(x, y));
        RenderImage bodyRenderImage = new RenderImage(ImageUtil.createColouredRobotImage(ImageUtil.getImage("/net/sf/robocode/ui/images/body.png"), color));
        bodyRenderImage.setTransform(AffineTransform.getRotateInstance(bodyAngle));
        bodyRenderImage.paint(g);
        RenderImage gunRenderImage = new RenderImage(ImageUtil.createColouredRobotImage(ImageUtil.getImage("/net/sf/robocode/ui/images/turret.png"), color));
        gunRenderImage.setTransform(AffineTransform.getRotateInstance(gunAngle));
        gunRenderImage.paint(g);
        RenderImage radarRenderImage = new RenderImage(ImageUtil.createColouredRobotImage(ImageUtil.getImage("/net/sf/robocode/ui/images/radar.png"), color));
        radarRenderImage.setTransform(AffineTransform.getRotateInstance(radarAngle));
        radarRenderImage.paint(g);
    }

    private void drawOuterDecoration(Graphics2D g) {
        Shape shape = this.getOuterDecoration();
        this.transform(g, AffineTransform.getTranslateInstance(26.0, 24.0));
        g.setColor(WHITE_ALPHA_7F);
        g.fill(shape);
        g.setStroke(THIN_STROKE);
        g.drawOval(16, 5, 490, 163);
    }

    private void drawMiddleEllipse(Graphics2D g) {
        this.transform(g, null);
        Ellipse2D.Float ellipse = new Ellipse2D.Float(68.0f, 38.0f, 440.0f, 146.0f);
        g.setColor(DARK_GREEN_ALPHA_80);
        g.fill(ellipse);
        g.setColor(GREEN_ALPHA_40);
        g.setStroke(THIN_STROKE);
        g.draw(ellipse);
    }

    private void drawMiddleDecoration(Graphics2D g) {
        Shape shape = this.getMiddleDecoration();
        this.transform(g, AffineTransform.getTranslateInstance(77.0, 41.0));
        g.setColor(GREEN_ALPHA_20);
        g.fill(shape);
        g.setStroke(THIN_STROKE);
        g.setColor(GREEN_ALPHA_48);
        g.draw(shape);
    }

    private void drawInnerDecoration(Graphics2D g) {
        Shape shape = this.getInnerDecoration();
        this.transform(g, AffineTransform.getTranslateInstance(103.0, 52.0));
        g.setColor(DARK_GREEN_ALPHA_80);
        g.fill(shape);
        g.setStroke(THIN_STROKE);
        g.setColor(GLOW_GREEN);
        g.draw(shape);
    }

    private void drawInnerSubDecoration(Graphics2D g) {
        Shape shape = this.getInnerSubDecoration();
        this.transform(g, AffineTransform.getTranslateInstance(110.0, 54.0));
        g.setColor(GREEN_ALPHA_08);
        g.fill(shape);
        g.setStroke(THIN_STROKE);
        g.setColor(GREEN_ALPHA_48);
        g.draw(shape);
    }

    private void drawRobocodeText(Graphics2D g) {
        GeneralPath shape = this.getRobocodeText();
        this.transform(g, AffineTransform.getTranslateInstance(121.0, 88.0));
        g.setColor(GREEN_ALPHA_40);
        g.fill(shape);
        g.setStroke(THIN_STROKE);
        g.setColor(GREEN_ALPHA_80);
        g.draw(shape);
    }

    private Shape getOuterDecoration() {
        if (this.outerDecoration == null) {
            float W = 523.0f;
            float H = 174.0f;
            this.outerDecoration = new Area(new Ellipse2D.Float(0.0f, 0.0f, W, H));
            this.outerDecoration.subtract(new Area(new Ellipse2D.Float(16.0f, 5.0f, W - 32.0f, H - 10.0f)));
            this.outerDecoration.subtract(new Area(new Rectangle2D.Float(W / 2.0f, 0.0f, W / 2.0f, H / 2.0f)));
            this.outerDecoration.subtract(new Area(new Rectangle2D.Float(0.0f, H / 2.0f, W / 2.0f, H / 2.0f)));
        }
        return this.outerDecoration;
    }

    private Shape getMiddleDecoration() {
        if (this.middleDecoration == null) {
            this.middleDecoration = new Area(new Ellipse2D.Float(0.0f, 0.0f, 420.0f, 140.0f));
            Rectangle2D.Float rect = new Rectangle2D.Float(180.0f, 69.0f, 500.0f, 3.0f);
            for (float deg = 120.0f; deg <= 335.0f; deg += 4.8f) {
                Area rectArea = new Area(rect);
                rectArea.transform(AffineTransform.getRotateInstance(Math.toRadians(deg), 151.0, 72.0));
                this.middleDecoration.subtract(rectArea);
            }
            this.middleDecoration.subtract(new Area(new Ellipse2D.Float(18.0f, 2.0f, 408.0f, 144.0f)));
        }
        return this.middleDecoration;
    }

    private Shape getInnerSubDecoration() {
        if (this.innerSubDecoration == null) {
            this.innerSubDecoration = new Area(new Ellipse2D.Float(0.0f, 0.0f, 356.0f, 114.0f));
            this.innerSubDecoration.subtract(new Area(new Rectangle2D.Float(Float.MIN_VALUE, Float.MIN_VALUE, Float.MAX_VALUE, 88.0f)));
            this.innerSubDecoration.subtract(new Area(new Rectangle2D.Float(Float.MIN_VALUE, Float.MIN_VALUE, 184.0f, Float.MAX_VALUE)));
            this.innerSubDecoration.subtract(new Area(new Rectangle2D.Float(209.0f, Float.MIN_VALUE, 3.0f, Float.MAX_VALUE)));
        }
        return this.innerSubDecoration;
    }

    private Shape getInnerDecoration() {
        if (this.innerDecoration == null) {
            this.innerDecoration = new Area(new Ellipse2D.Float(0.0f, 0.0f, 368.0f, 120.0f));
            this.innerDecoration.subtract(new Area(new Rectangle2D.Float(Float.MIN_VALUE, 30.0f, Float.MAX_VALUE, 56.0f)));
            this.innerDecoration.subtract(new Area(new Rectangle2D.Float(181.0f, Float.MIN_VALUE, 7.0f, Float.MAX_VALUE)));
        }
        return this.innerDecoration;
    }

    public GeneralPath getRobocodeText() {
        if (this.robocodeTextPath == null) {
            this.robocodeTextPath = new GeneralPath();
            GeneralPath R = this.getPathR();
            GeneralPath o = this.getPathO();
            GeneralPath b = this.getPathB();
            GeneralPath c = this.getPathC();
            GeneralPath d = this.getPathD();
            GeneralPath e = this.getPathE();
            this.robocodeTextPath.append(R, false);
            o.transform(AffineTransform.getTranslateInstance(42.0, 16.0));
            this.robocodeTextPath.append(o, false);
            b.transform(AffineTransform.getTranslateInstance(84.0, 0.0));
            this.robocodeTextPath.append(b, false);
            o.transform(AffineTransform.getTranslateInstance(85.0, 0.0));
            this.robocodeTextPath.append(o, false);
            c.transform(AffineTransform.getTranslateInstance(170.0, 16.0));
            this.robocodeTextPath.append(c, false);
            o.transform(AffineTransform.getTranslateInstance(77.0, 0.0));
            this.robocodeTextPath.append(o, false);
            d.transform(AffineTransform.getTranslateInstance(246.0, 0.0));
            this.robocodeTextPath.append(d, false);
            e.transform(AffineTransform.getTranslateInstance(290.0, 16.0));
            this.robocodeTextPath.append(e, false);
        }
        return this.robocodeTextPath;
    }

    private GeneralPath getPathR() {
        GeneralPath path = new GeneralPath(I_SHAPE);
        GeneralPath bow = this.getPathPBow();
        bow.transform(AffineTransform.getTranslateInstance(15.0, 0.0));
        path.append(bow, false);
        path.moveTo(21.0f, 29.0f);
        path.lineTo(31.0f, 46.0f);
        path.lineTo(44.5f, 46.0f);
        path.lineTo(33.5f, 27.0f);
        path.curveTo(33.5f, 27.0f, 31.0f, 29.0f, 21.0f, 29.0f);
        path.closePath();
        return path;
    }

    private GeneralPath getPathO() {
        GeneralPath path = this.getPathOBow();
        path.transform(AffineTransform.getTranslateInstance(20.0, 0.0));
        GeneralPath bow2 = this.getPathOBow();
        bow2.transform(AffineTransform.getScaleInstance(-1.0, 1.0));
        bow2.transform(AffineTransform.getTranslateInstance(18.0, 0.0));
        path.append(bow2, false);
        return path;
    }

    private GeneralPath getPathB() {
        GeneralPath path = new GeneralPath(I_SHAPE);
        GeneralPath bow = this.getPathPBow();
        bow.transform(AffineTransform.getTranslateInstance(15.0, 20.0));
        path.append(bow, false);
        return path;
    }

    private GeneralPath getPathC() {
        GeneralPath path = this.getPathCBow();
        GeneralPath bow2 = this.getPathCBow();
        bow2.transform(AffineTransform.getScaleInstance(1.0, -1.0));
        bow2.transform(AffineTransform.getTranslateInstance(0.0, 31.0));
        path.append(bow2, false);
        return path;
    }

    private GeneralPath getPathD() {
        GeneralPath path = new GeneralPath(I_SHAPE);
        path.transform(AffineTransform.getTranslateInstance(27.0, 0.0));
        GeneralPath bow = this.getPathPBow();
        bow.transform(AffineTransform.getScaleInstance(-1.0, 1.0));
        bow.transform(AffineTransform.getTranslateInstance(25.0, 20.0));
        path.append(bow, false);
        return path;
    }

    private GeneralPath getPathE() {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 14.5f);
        path.lineTo(31.0f, 14.5f);
        path.curveTo(31.0f, -4.5f, 0.0f, -4.5f, 0.0f, 14.5f);
        path.closePath();
        path.moveTo(12.0f, 11.0f);
        path.lineTo(20.0f, 11.0f);
        path.curveTo(20.0f, 8.0f, 12.0f, 8.0f, 12.0f, 11.0f);
        path.closePath();
        GeneralPath bow2 = this.getPathCBow();
        bow2.transform(AffineTransform.getScaleInstance(1.0, -1.0));
        bow2.transform(AffineTransform.getTranslateInstance(0.0, 31.0));
        path.append(bow2, false);
        return path;
    }

    private GeneralPath getPathPBow() {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(10.0f, 0.0f);
        path.curveTo(30.0f, 0.0f, 30.0f, 26.0f, 10.0f, 26.0f);
        path.lineTo(0.0f, 26.0f);
        path.lineTo(0.0f, 17.0f);
        path.lineTo(8.0f, 17.0f);
        path.curveTo(14.0f, 18.0f, 14.0f, 9.0f, 8.0f, 9.0f);
        path.lineTo(0.0f, 9.0f);
        path.lineTo(0.0f, 0.0f);
        path.closePath();
        return path;
    }

    private GeneralPath getPathOBow() {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.curveTo(23.0f, 0.0f, 23.0f, 31.0f, 0.0f, 31.0f);
        path.lineTo(0.0f, 20.0f);
        path.curveTo(8.0f, 20.0f, 8.0f, 11.0f, 0.0f, 11.0f);
        path.lineTo(0.0f, 0.0f);
        path.closePath();
        return path;
    }

    private GeneralPath getPathCBow() {
        GeneralPath path = new GeneralPath();
        path.moveTo(31.0f, 12.0f);
        path.curveTo(29.0f, -3.5f, 2.0f, -5.5f, 0.0f, 14.5f);
        path.lineTo(11.0f, 14.5f);
        path.curveTo(11.0f, 8.5f, 18.0f, 9.0f, 18.0f, 12.0f);
        path.lineTo(31.0f, 12.0f);
        path.closePath();
        return path;
    }
}

