/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.ui.packager;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.robocode.repository.IRobotSpecItem;
import net.sf.robocode.ui.dialog.WizardPanel;
import net.sf.robocode.ui.packager.RobotPackager;
import net.sf.robocode.ui.util.LimitedDocument;

public class PackagerOptionsPanel
extends WizardPanel {
    private final RobotPackager robotPackager;
    private final EventHandler eventHandler = new EventHandler();
    private JCheckBox includeSource;
    private JCheckBox includeData;
    private JLabel authorLabel;
    private JTextField authorField;
    private JLabel descriptionLabel;
    private JTextArea descriptionArea;
    private JLabel versionLabel;
    private JTextField versionField;
    private JLabel versionHelpLabel;
    private JLabel webpageLabel;
    private JTextField webpageField;
    private JLabel webpageHelpLabel;
    private List<IRobotSpecItem> currentSelectedRobots;
    public JPanel robotListPanel;

    public PackagerOptionsPanel(RobotPackager robotPackager) {
        this.robotPackager = robotPackager;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        JLabel label = new JLabel("It is up to you whether or not to include the source files when you distribute your robot.");
        label.setAlignmentX(0.0f);
        this.add(label);
        label = new JLabel("If you include the source files, other people will be able to look at your code and learn from it.");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.getIncludeSource().setAlignmentX(0.0f);
        this.add(this.getIncludeSource());
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        label = new JLabel("You may include the source files too if they are available?");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.getIncludeData().setAlignmentX(0.0f);
        this.add(this.getIncludeData());
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getVersionLabel());
        JPanel versionPanel = new JPanel();
        versionPanel.setLayout(new FlowLayout(0, 0, 0));
        versionPanel.setAlignmentX(0.0f);
        this.getVersionField().setAlignmentX(0.0f);
        this.getVersionField().setMaximumSize(this.getVersionField().getPreferredSize());
        versionPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getVersionField().getPreferredSize().height));
        versionPanel.add(this.getVersionField());
        versionPanel.add(this.getVersionHelpLabel());
        this.add(versionPanel);
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getDescriptionLabel());
        JScrollPane scrollPane = new JScrollPane(this.getDescriptionArea(), 21, 32);
        scrollPane.setMaximumSize(scrollPane.getPreferredSize());
        scrollPane.setMinimumSize(new Dimension(100, scrollPane.getPreferredSize().height));
        scrollPane.setAlignmentX(0.0f);
        this.add(scrollPane);
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getAuthorLabel());
        this.getAuthorField().setAlignmentX(0.0f);
        this.getAuthorField().setMaximumSize(this.getAuthorField().getPreferredSize());
        this.add(this.getAuthorField());
        label = new JLabel(" ");
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(this.getWebpageLabel());
        this.getWebpageField().setAlignmentX(0.0f);
        this.getWebpageField().setMaximumSize(this.getWebpageField().getPreferredSize());
        this.add(this.getWebpageField());
        this.getWebpageHelpLabel().setAlignmentX(0.0f);
        this.add(this.getWebpageHelpLabel());
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        this.add(panel);
        this.addComponentListener(this.eventHandler);
    }

    @Override
    public boolean isReady() {
        String text;
        if (this.getVersionLabel().isVisible() && ((text = this.getVersionField().getText()).length() == 0 || !text.matches("([a-zA-Z0-9.])*[a-zA-Z0-9]+"))) {
            return false;
        }
        return this.getDescriptionArea().getText().length() != 0;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("options");
        frame.setSize(new Dimension(500, 300));
        frame.getContentPane().add(new PackagerOptionsPanel(null));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        try {
            SwingUtilities.invokeAndWait(new PackAndShowFrameWorker(frame));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public JCheckBox getIncludeSource() {
        if (this.includeSource == null) {
            this.includeSource = new JCheckBox("Include source files", true);
        }
        return this.includeSource;
    }

    public JCheckBox getIncludeData() {
        if (this.includeData == null) {
            this.includeData = new JCheckBox("Include data files", true);
        }
        return this.includeData;
    }

    private JLabel getAuthorLabel() {
        if (this.authorLabel == null) {
            this.authorLabel = new JLabel("Please enter your name. (optional)");
            this.authorLabel.setAlignmentX(0.0f);
        }
        return this.authorLabel;
    }

    public JTextField getAuthorField() {
        if (this.authorField == null) {
            this.authorField = new JTextField(40);
        }
        return this.authorField;
    }

    public JLabel getDescriptionLabel() {
        if (this.descriptionLabel == null) {
            this.descriptionLabel = new JLabel("");
            this.descriptionLabel.setAlignmentX(0.0f);
        }
        return this.descriptionLabel;
    }

    public JTextArea getDescriptionArea() {
        if (this.descriptionArea == null) {
            LimitedDocument doc = new LimitedDocument(3, 72);
            this.descriptionArea = new JTextArea(doc, null, 3, 72);
            doc.addDocumentListener(this.eventHandler);
        }
        return this.descriptionArea;
    }

    private JLabel getVersionLabel() {
        if (this.versionLabel == null) {
            this.versionLabel = new JLabel("Please enter a version number for this robot (up to 10 word chars: letters, digits, dots, but no spaces).");
            this.versionLabel.setAlignmentX(0.0f);
        }
        return this.versionLabel;
    }

    public JTextField getVersionField() {
        if (this.versionField == null) {
            LimitedDocument doc = new LimitedDocument(1, 10);
            this.versionField = new JTextField(doc, null, 10);
            doc.addDocumentListener(this.eventHandler);
        }
        return this.versionField;
    }

    public JLabel getVersionHelpLabel() {
        if (this.versionHelpLabel == null) {
            this.versionHelpLabel = new JLabel("<-- Make sure to delete the asterisk and type in a new version number");
        }
        return this.versionHelpLabel;
    }

    public JLabel getWebpageLabel() {
        if (this.webpageLabel == null) {
            this.webpageLabel = new JLabel("Please enter a URL for your robot's webpage. (optional)");
            this.webpageLabel.setAlignmentX(0.0f);
        }
        return this.webpageLabel;
    }

    public JTextField getWebpageField() {
        if (this.webpageField == null) {
            this.webpageField = new JTextField(40);
        }
        return this.webpageField;
    }

    public JLabel getWebpageHelpLabel() {
        if (this.webpageHelpLabel == null) {
            this.webpageHelpLabel = new JLabel("");
        }
        return this.webpageHelpLabel;
    }

    static class PackAndShowFrameWorker
    implements Runnable {
        final JFrame frame;

        public PackAndShowFrameWorker(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public void run() {
            if (this.frame != null) {
                this.frame.pack();
                this.frame.setVisible(true);
            }
        }
    }

    private class EventHandler
    implements ComponentListener,
    KeyListener,
    DocumentListener {
        private EventHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PackagerOptionsPanel.this.fireStateChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PackagerOptionsPanel.this.fireStateChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PackagerOptionsPanel.this.fireStateChanged();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            List<IRobotSpecItem> selectedRobots = PackagerOptionsPanel.this.robotPackager.getRobotSelectionPanel().getSelectedRobots();
            if (selectedRobots == null || selectedRobots.equals(PackagerOptionsPanel.this.currentSelectedRobots)) {
                return;
            }
            PackagerOptionsPanel.this.currentSelectedRobots = selectedRobots;
            if (selectedRobots.size() == 1) {
                IRobotSpecItem robotSpecItem = selectedRobots.get(0);
                PackagerOptionsPanel.this.getIncludeSource().setSelected(robotSpecItem.getIncludeSource());
                PackagerOptionsPanel.this.getIncludeData().setSelected(robotSpecItem.getIncludeData());
                String ver = robotSpecItem.getVersion();
                if (ver == null || ver.length() == 0) {
                    PackagerOptionsPanel.this.getVersionHelpLabel().setVisible(false);
                    ver = "1.0";
                } else {
                    if (ver.length() == 10) {
                        ver = ver.substring(0, 9);
                    }
                    ver = ver + "*";
                    PackagerOptionsPanel.this.getVersionHelpLabel().setVisible(true);
                }
                PackagerOptionsPanel.this.getVersionField().setText(ver);
                String desc = robotSpecItem.getDescription();
                if (desc == null) {
                    desc = "";
                }
                PackagerOptionsPanel.this.getDescriptionArea().setText(desc);
                String author = robotSpecItem.getAuthorName();
                if (author == null) {
                    author = "";
                }
                PackagerOptionsPanel.this.getAuthorField().setText(author);
                URL url = robotSpecItem.getWebpage();
                String webPage = url != null ? url.toString() : "";
                PackagerOptionsPanel.this.getWebpageField().setText(webPage);
                String fullPackage = robotSpecItem.getFullPackage();
                String text = "";
                if (fullPackage != null && fullPackage.indexOf(".") != -1) {
                    String htmlFileName = fullPackage.substring(0, fullPackage.lastIndexOf(".")) + ".html";
                    text = "(You may also leave this blank, and simply create the file: " + htmlFileName + ")";
                }
                PackagerOptionsPanel.this.getWebpageHelpLabel().setText(text);
                PackagerOptionsPanel.this.getVersionLabel().setVisible(true);
                PackagerOptionsPanel.this.getVersionField().setVisible(true);
                PackagerOptionsPanel.this.getAuthorLabel().setVisible(true);
                PackagerOptionsPanel.this.getAuthorField().setVisible(true);
                PackagerOptionsPanel.this.getWebpageLabel().setVisible(true);
                PackagerOptionsPanel.this.getWebpageField().setVisible(true);
                PackagerOptionsPanel.this.getWebpageHelpLabel().setVisible(true);
                PackagerOptionsPanel.this.getDescriptionLabel().setText("Please enter a short description of your robot (up to 3 lines of 72 chars each).");
            } else if (selectedRobots.size() > 1) {
                PackagerOptionsPanel.this.getVersionLabel().setVisible(false);
                PackagerOptionsPanel.this.getVersionField().setVisible(false);
                PackagerOptionsPanel.this.getVersionHelpLabel().setVisible(false);
                PackagerOptionsPanel.this.getAuthorLabel().setVisible(false);
                PackagerOptionsPanel.this.getAuthorField().setVisible(false);
                PackagerOptionsPanel.this.getWebpageLabel().setVisible(false);
                PackagerOptionsPanel.this.getWebpageField().setVisible(false);
                PackagerOptionsPanel.this.getWebpageHelpLabel().setVisible(false);
                PackagerOptionsPanel.this.getDescriptionLabel().setText("Please enter a short description of this robot collection (up to 3 lines of 72 chars each).");
                if (PackagerOptionsPanel.this.getDescriptionArea().getText() == null || PackagerOptionsPanel.this.getDescriptionArea().getText().length() == 0) {
                    PackagerOptionsPanel.this.getDescriptionArea().setText("(Example)This robot comes from the ... robot collection\n");
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

