/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.Platform;
import net.sf.saxon.java.JavaPlatform;

public final class Version {
    private static final int MAJOR_VERSION = 11;
    private static final int MINOR_VERSION = 1;
    private static final int BUILD = 20416;
    private static final String MAJOR_RELEASE_DATE = "2021-10-05";
    private static final String MINOR_RELEASE_DATE = "2022-02-04";
    public static String softwareEdition = "HE";
    public static Platform platform = new JavaPlatform();

    private Version() {
    }

    public static String getProductName() {
        return "SAXON";
    }

    public static String getProductVendor() {
        return "Saxonica";
    }

    public static String getProductVariantAndVersion(String edition) {
        return edition + " " + Version.getProductVersion();
    }

    public static String getProductVersion() {
        return "11.1";
    }

    public static int[] getStructuredVersionNumber() {
        return new int[]{11, 1, 20416};
    }

    public static String getReleaseDate() {
        return MINOR_RELEASE_DATE;
    }

    public static String getMajorReleaseDate() {
        return MAJOR_RELEASE_DATE;
    }

    public static String getProductTitle() {
        return Version.getProductName() + '-' + Version.getSoftwarePlatform() + '-' + softwareEdition + ' ' + Version.getProductVersion() + " from Saxonica";
    }

    public static String getSoftwarePlatform() {
        return "J";
    }

    public static String getWebSiteAddress() {
        return "http://www.saxonica.com/";
    }

    public static void main(String[] args) {
        System.err.println(Version.getProductTitle() + " (build " + 20416 + ')');
        if (args.length > 0 && args[0].equals("-resources")) {
            platform.showEmbeddedResources();
        }
    }
}

