/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.AbstractUniStringConsumer;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.Twine16;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntPredicateProxy;

public abstract class UnparsedTextFunction
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] arguments) {
        int p = super.getSpecialProperties(arguments);
        if (this.getRetainedStaticContext().getConfiguration().getBooleanProperty(Feature.STABLE_UNPARSED_TEXT)) {
            return p;
        }
        return p & 0xFF7FFFFF;
    }

    public static void readFile(URI absoluteURI, String encoding, UniStringConsumer output, XPathContext context) throws XPathException {
        Reader reader;
        Configuration config = context.getConfiguration();
        IntPredicateProxy checker = config.getValidCharacterChecker();
        try {
            reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("FOUT1170");
            throw err;
        }
        if (reader == null) {
            ResourceRequest request = new ResourceRequest();
            request.uri = absoluteURI.toString();
            request.nature = "https://www.iana.org/assignments/media-types/text/plain";
            Source src = request.resolve(config.getResourceResolver(), new DirectResourceResolver(config));
            if (src instanceof StreamSource) {
                reader = StandardUnparsedTextResolver.getReaderFromStreamSource((StreamSource)src, encoding, config, false);
            } else {
                throw new XPathException("unparsed-text(): resolver returned non-StreamSource");
            }
        }
        try {
            UnparsedTextFunction.readFile(checker, reader, output);
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException e = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            e.setErrorCode("FOUT1190");
            throw e;
        }
        catch (IOException ioErr) {
            throw UnparsedTextFunction.handleIOError(absoluteURI, ioErr);
        }
    }

    public static URI getAbsoluteURI(String href, String baseURI, XPathContext context) throws XPathException {
        URI absoluteURI;
        try {
            absoluteURI = ResolveURI.makeAbsolute(href, baseURI);
        }
        catch (URISyntaxException err) {
            UnparsedTextFunction.handleURISyntaxException(href, baseURI, err);
            return null;
        }
        if (absoluteURI.getFragment() != null) {
            XPathException e = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            e.setErrorCode("FOUT1170");
            throw e;
        }
        EncodeForUri.checkPercentEncoding(absoluteURI.toString());
        return absoluteURI;
    }

    private static void handleURISyntaxException(String href, String baseURI, URISyntaxException err) throws XPathException {
        XPathException e = new XPathException(err.getReason() + ": " + err.getInput(), err);
        e.setErrorCode("FOUT1170");
        throw e;
    }

    public static XPathException handleIOError(URI absoluteURI, IOException ioErr) {
        String message = "Failed to read input file";
        if (absoluteURI != null && !ioErr.getMessage().equals(absoluteURI.toString())) {
            message = message + ' ' + absoluteURI.toString();
        }
        message = message + " (" + ioErr.getClass().getName() + ')';
        XPathException e = new XPathException(message, ioErr);
        String errorCode = UnparsedTextFunction.getErrorCode(ioErr);
        e.setErrorCode(errorCode);
        return e;
    }

    public static String getErrorCode(IOException ioErr) {
        if (ioErr instanceof MalformedInputException) {
            return "FOUT1200";
        }
        if (ioErr instanceof UnmappableCharacterException) {
            return "FOUT1200";
        }
        if (ioErr instanceof CharacterCodingException) {
            return "FOUT1200";
        }
        return "FOUT1170";
    }

    public static UnicodeString readFile(IntPredicateProxy checker, Reader reader) throws IOException, XPathException {
        final UnicodeBuilder buffer = new UnicodeBuilder();
        UnparsedTextFunction.readFile(checker, reader, new AbstractUniStringConsumer(){

            @Override
            public UniStringConsumer accept(UnicodeString chars) {
                return buffer.accept(chars);
            }
        });
        return buffer.toUnicodeString();
    }

    public static void readFile(IntPredicateProxy checker, Reader reader, UniStringConsumer output) throws IOException, XPathException {
        char[] buffer = new char[2048];
        boolean first = true;
        int line = 1;
        int column = 1;
        int mask = 0;
        while (true) {
            int actual;
            try {
                actual = reader.read(buffer, 0, buffer.length);
            }
            catch (IllegalStateException e) {
                throw new IOException(e.getMessage(), e);
            }
            if (UnparsedTextFunction.isEndOfFile(actual)) break;
            int c = 0;
            while (c < actual) {
                int ch32;
                if ((ch32 = buffer[c++]) == 10) {
                    ++line;
                    column = 0;
                }
                ++column;
                mask |= ch32;
                if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                    if (c == actual) {
                        char[] buffer2 = new char[2048];
                        int actual2 = reader.read(buffer2, 0, 2048);
                        char[] buffer3 = new char[actual + actual2];
                        System.arraycopy(buffer, 0, buffer3, 0, actual);
                        System.arraycopy(buffer2, 0, buffer3, actual, actual2);
                        buffer = buffer3;
                        actual += actual2;
                    }
                    char low = buffer[c++];
                    ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
                    mask |= ch32;
                }
                if (checker.test(ch32)) continue;
                XPathException err = new XPathException("The text file contains a character that is illegal in XML (line=" + line + " column=" + column + " value=hex " + Integer.toHexString(ch32) + ')');
                err.setErrorCode("FOUT1190");
                throw err;
            }
            int start = 0;
            int len = actual--;
            if (first) {
                if (buffer[0] == '\ufeff') {
                    start = 1;
                }
                first = false;
            }
            if (mask <= 255) {
                output.accept(new Twine8(buffer, start, actual));
                continue;
            }
            if (mask <= 65535) {
                output.accept(new Twine16(buffer, start, actual));
                continue;
            }
            output.accept(StringView.of(new String(buffer, start, len)));
        }
        reader.close();
    }

    private static boolean isEndOfFile(int bytesRead) {
        return bytesRead < 0;
    }
}

