/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Properties;
import net.sf.saxon.event.ReceiverWithOutputProperties;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.trans.XPathException;

public abstract class Emitter
extends SequenceReceiver
implements ReceiverWithOutputProperties {
    protected UnicodeWriter writer;
    protected Properties outputProperties;
    protected CharacterSet characterSet;
    protected boolean allCharactersEncodable = false;
    private boolean mustClose = false;

    public Emitter() {
        super(null);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        if (this.characterSet == null) {
            this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(details);
            this.allCharactersEncodable = this.characterSet instanceof UTF8CharacterSet || this.characterSet instanceof UTF16CharacterSet;
        }
        this.outputProperties = details;
    }

    @Override
    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setUnicodeWriter(UnicodeWriter unicodeWriter) {
        this.writer = unicodeWriter;
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        if (this.mustClose && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new XPathException("Failed to close output stream");
            }
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item instanceof NodeInfo) {
            this.decompose(item, locationId, copyNamespaces);
        } else {
            this.characters(item.getUnicodeStringValue(), locationId, 0);
        }
    }
}

