/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;

public class ResourceResolverWrappingURIResolver
implements ResourceResolver {
    private final URIResolver uriResolver;

    public ResourceResolverWrappingURIResolver(URIResolver uriResolver) {
        Objects.requireNonNull(uriResolver);
        this.uriResolver = uriResolver;
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        if (request.relativeUri != null && request.baseUri != null) {
            try {
                return this.uriResolver.resolve(request.relativeUri, request.baseUri);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        if (request.uri != null) {
            try {
                return this.uriResolver.resolve(request.uri, request.baseUri);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        return null;
    }

    public URIResolver getWrappedURIResolver() {
        return this.uriResolver;
    }
}

