/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.query.InputStreamMarker;
import net.sf.saxon.resource.EncodingDetector;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.resource.TypedStreamSource;
import net.sf.saxon.trans.XPathException;

public class StandardUnparsedTextResolver
implements UnparsedTextURIResolver {
    private boolean debug = false;

    public void setDebugging(boolean debug) {
        this.debug = debug;
    }

    @Override
    public Reader resolve(URI absoluteURI, String encoding, Configuration config) throws XPathException {
        Logger err = config.getLogger();
        if (this.debug) {
            err.info("unparsed-text(): processing " + absoluteURI);
            err.info("unparsed-text(): requested encoding = " + encoding);
        }
        if (!absoluteURI.isAbsolute()) {
            throw new XPathException("Resolved URI supplied to unparsed-text() is not absolute: " + absoluteURI.toString(), "FOUT1170");
        }
        ResourceRequest rr = new ResourceRequest();
        rr.uri = absoluteURI.toString();
        rr.nature = "https://www.iana.org/assignments/media-types/text/plain";
        rr.purpose = "fn:unparsed-text";
        Source resolved = rr.resolve(config.getResourceResolver(), new DirectResourceResolver(config));
        if (resolved == null) {
            throw new XPathException("unparsed-text(): failed to resolve URI " + absoluteURI);
        }
        if (resolved instanceof StreamSource) {
            return StandardUnparsedTextResolver.getReaderFromStreamSource((StreamSource)resolved, encoding, config, this.debug);
        }
        throw new XPathException("Resolver for unparsed-text() returned non-StreamSource");
    }

    public static Reader getReaderFromStreamSource(StreamSource source, String encoding, Configuration config, boolean debug) throws XPathException {
        Logger err = config.getLogger();
        InputStream inputStream = source.getInputStream();
        if (inputStream == null) {
            if (source.getReader() != null) {
                return source.getReader();
            }
            String systemId = source.getSystemId();
            if (systemId != null) {
                try {
                    if (systemId.startsWith("classpath:")) {
                        inputStream = StandardUnparsedTextResolver.openClasspathResource(config, systemId);
                    }
                    URL url = new URL(systemId);
                    inputStream = ResourceLoader.urlStream(url);
                }
                catch (IOException e) {
                    throw new XPathException("unparsed-text(): cannot retrieve " + systemId, e);
                }
            } else {
                throw new XPathException("unparsed-text(): resolver returned empty StreamSource");
            }
        }
        String contentType = null;
        if (source instanceof TypedStreamSource) {
            contentType = ((TypedStreamSource)source).getContentType();
        }
        if (debug) {
            err.info("unparsed-text(): content type = " + contentType);
        }
        boolean isXmlMediaType = false;
        if (contentType != null) {
            int pos = contentType.indexOf(59);
            String mediaType = pos >= 0 ? contentType.substring(0, pos) : contentType;
            mediaType = mediaType.trim();
            if (debug) {
                err.info("unparsed-text(): media type = " + mediaType);
            }
            isXmlMediaType = !(!mediaType.startsWith("application/") && !mediaType.startsWith("text/") || !mediaType.endsWith("/xml") && !mediaType.endsWith("+xml"));
            String charset = "";
            pos = contentType.toLowerCase().indexOf("charset");
            if (pos >= 0) {
                if ((pos = contentType.indexOf(61, pos + 7)) >= 0) {
                    charset = contentType.substring(pos + 1);
                }
                if ((pos = charset.indexOf(59)) > 0) {
                    charset = charset.substring(0, pos);
                }
                if ((pos = charset.indexOf(40)) > 0) {
                    charset = charset.substring(0, pos);
                }
                if ((pos = charset.indexOf(34)) > 0) {
                    charset = charset.substring(pos + 1, charset.indexOf(34, pos + 2));
                }
                if (debug) {
                    err.info("unparsed-text(): charset = " + charset.trim());
                }
                encoding = charset.trim();
            }
        }
        try {
            if (encoding == null || isXmlMediaType) {
                inputStream = InputStreamMarker.ensureMarkSupported(inputStream);
                encoding = EncodingDetector.inferStreamEncoding(inputStream, debug ? err : null);
                if (debug) {
                    err.info("unparsed-text(): inferred encoding = " + encoding);
                }
            }
        }
        catch (IOException e) {
            encoding = "UTF-8";
        }
        return StandardUnparsedTextResolver.makeReaderFromStream(inputStream, encoding);
    }

    private static InputStream openClasspathResource(Configuration config, String systemId) throws XPathException {
        return config.getClass().getClassLoader().getResourceAsStream(systemId.substring(10));
    }

    private static Reader makeReaderFromStream(InputStream stream, String encoding) throws XPathException {
        try {
            Charset charset2 = Charset.forName(encoding);
            CharsetDecoder decoder = charset2.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            return new BufferedReader(new InputStreamReader(stream, decoder));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException icne) {
            throw new XPathException("Invalid encoding name: " + encoding, "FOUT1190");
        }
    }
}

