/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Collections;
import java.util.function.Supplier;
import net.sf.saxon.expr.DefaultedArgumentExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.registry.FunctionDefinition;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.SequenceType;

public abstract class FunctionCall
extends Expression {
    private OperandArray operanda;

    protected void setOperanda(OperandArray operanda) {
        this.operanda = operanda;
    }

    public OperandArray getOperanda() {
        return this.operanda;
    }

    @Override
    public Iterable<Operand> operands() {
        if (this.operanda != null) {
            return this.operanda;
        }
        return Collections.emptyList();
    }

    public abstract FunctionItem getTargetFunction(XPathContext var1) throws XPathException;

    public abstract StructuredQName getFunctionName();

    public final int getArity() {
        return this.getOperanda().getNumberOfOperands();
    }

    public void setArguments(Expression[] args) {
        this.setOperanda(new OperandArray(this, args));
    }

    protected void setOperanda(Expression[] args, OperandRole[] roles) {
        this.setOperanda(new OperandArray((Expression)this, args, roles));
    }

    public Expression[] getArguments() {
        Expression[] result = new Expression[this.getArity()];
        int i = 0;
        for (Operand o : this.operands()) {
            result[i++] = o.getChildExpression();
        }
        return result;
    }

    public Expression getArg(int n) {
        return this.getOperanda().getOperandExpression(n);
    }

    public void setArg(int n, Expression child) {
        this.getOperanda().setOperand(n, child);
        this.adoptChildExpression(child);
    }

    protected final Expression simplifyArguments(StaticContext env) throws XPathException {
        for (int i = 0; i < this.getArguments().length; ++i) {
            Expression exp = this.getArg(i).simplify();
            if (exp == this.getArg(i)) continue;
            this.adoptChildExpression(exp);
            this.setArg(i, exp);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        this.checkArguments(visitor);
        return this.preEvaluateIfConstant(visitor);
    }

    protected Expression preEvaluateIfConstant(ExpressionVisitor visitor) throws XPathException {
        Optimizer opt = visitor.obtainOptimizer();
        if (opt.isOptionSet(32768)) {
            boolean fixed = true;
            for (Operand o : this.operands()) {
                if (o.getChildExpression() instanceof Literal) continue;
                fixed = false;
            }
            if (fixed) {
                try {
                    return this.preEvaluate(visitor);
                }
                catch (NoDynamicContextException err) {
                    return this;
                }
            }
        }
        return this;
    }

    public void checkFunctionCall(FunctionItem target, ExpressionVisitor visitor) throws XPathException {
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(visitor.getStaticContext().isInBackwardsCompatibleMode());
        SequenceType[] argTypes = target.getFunctionItemType().getArgumentTypes();
        FunctionDefinition fd = null;
        if (target instanceof FunctionDefinition) {
            fd = (FunctionDefinition)((Object)target);
        }
        if (target.isSequenceVariadic() && this.getArity() == 1) {
            String name = this.getFunctionName() == null ? "" : this.getFunctionName().getDisplayName();
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(0, name, 0);
            this.setArg(0, tc.staticTypeCheck(this.getArg(0), new SequenceType(argTypes[0].getPrimaryType(), 57344), role, visitor));
        } else {
            int n = target.getArity();
            for (int i = 0; i < n; ++i) {
                int pos = i;
                Supplier<RoleDiagnostic> role = () -> {
                    String name = this.getFunctionName() == null ? "" : this.getFunctionName().getDisplayName();
                    return new RoleDiagnostic(0, name, pos);
                };
                Expression arg = this.getArg(i);
                if (arg instanceof DefaultedArgumentExpression && fd != null) {
                    if (i < fd.getMinimumArity()) {
                        throw new XPathException("No value supplied for " + RoleDiagnostic.ordinal(i + 1) + " parameter of function " + (this.getFunctionName() == null ? "" : this.getFunctionName().getDisplayName()), "XPST0141");
                    }
                    arg = fd.getDefaultValueExpression(i);
                }
                if (arg == null || arg instanceof DefaultedArgumentExpression) continue;
                this.setArg(i, tc.staticTypeCheck(arg, argTypes[i], role, visitor));
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.optimizeChildren(visitor, contextItemType);
        Optimizer opt = visitor.obtainOptimizer();
        if (opt.isOptionSet(32768)) {
            boolean fixed = true;
            for (Operand o : this.operands()) {
                if (o.getChildExpression() instanceof Literal) continue;
                fixed = false;
                break;
            }
            if (fixed) {
                return this.preEvaluate(visitor);
            }
        }
        return this;
    }

    @Override
    public int getNetCost() {
        return 5;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if ((this.getIntrinsicDependencies() & 0xFFFFF7FF) != 0) {
            return this;
        }
        try {
            try {
                Literal lit = Literal.makeLiteral(SequenceTool.toGroundedValue(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext())), this);
                Optimizer.trace(visitor.getConfiguration(), "Pre-evaluated function call " + this.toShortString(), lit);
                return lit;
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
        catch (NoDynamicContextException e) {
            return this;
        }
        catch (UnsupportedOperationException e) {
            if (e.getCause() instanceof NoDynamicContextException) {
                return this;
            }
            throw e;
        }
    }

    protected void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    protected int checkArgumentCount(int min, int max) throws XPathException {
        int numArgs = this.getArity();
        String msg = null;
        if (min == max && numArgs != min) {
            msg = "Function " + this.getDisplayName() + " must have " + FunctionCall.pluralArguments(min);
        } else if (numArgs < min) {
            msg = "Function " + this.getDisplayName() + " must have at least " + FunctionCall.pluralArguments(min);
        } else if (numArgs > max) {
            msg = "Function " + this.getDisplayName() + " must have no more than " + FunctionCall.pluralArguments(max);
        }
        if (msg != null) {
            XPathException err = new XPathException(msg, "XPST0017");
            err.setIsStaticError(true);
            err.setLocation(this.getLocation());
            throw err;
        }
        return numArgs;
    }

    @Override
    public int getImplementationMethod() {
        return 3;
    }

    public static String pluralArguments(int num) {
        return num == 1 ? "one argument" : num + " arguments";
    }

    public PathMap.PathMapNodeSet addExternalFunctionCallToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (Operand o : this.operands()) {
            result.addNodeSet(o.getChildExpression().addToPathMap(pathMap, pathMapNodes));
        }
        result.setHasUnknownDependencies();
        return result;
    }

    @Override
    public String getExpressionName() {
        return "functionCall";
    }

    public final String getDisplayName() {
        StructuredQName fName = this.getFunctionName();
        return fName == null ? "(anonymous)" : fName.getDisplayName();
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder(64);
        StructuredQName fName = this.getFunctionName();
        String f = fName == null ? "$anonymousFunction" : (fName.hasURI(NamespaceUri.FN) ? fName.getLocalPart() : fName.getEQName());
        buff.append(f);
        boolean first = true;
        for (Operand o : this.operands()) {
            buff.append(first ? "(" : ", ");
            buff.append(o.getChildExpression().toString());
            first = false;
        }
        buff.append(first ? "()" : ")");
        return buff.toString();
    }

    @Override
    public String toShortString() {
        StructuredQName fName = this.getFunctionName();
        return (fName == null ? "$anonFn" : fName.getDisplayName()) + "(" + (this.getArity() == 0 ? "" : "...") + ")";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("functionCall", this);
        if (this.getFunctionName() == null) {
            throw new AssertionError((Object)"Exporting call to anonymous function");
        }
        out.emitAttribute("name", this.getFunctionName().getDisplayName());
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        if (this.getFunctionName() == null) {
            return this == o;
        }
        FunctionCall f = (FunctionCall)o;
        if (!this.getFunctionName().equals(f.getFunctionName())) {
            return false;
        }
        if (this.getArity() != f.getArity()) {
            return false;
        }
        for (int i = 0; i < this.getArity(); ++i) {
            if (this.getArg(i).isEqual(f.getArg(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int computeHashCode() {
        if (this.getFunctionName() == null) {
            return super.computeHashCode();
        }
        int h = this.getFunctionName().hashCode();
        for (int i = 0; i < this.getArity(); ++i) {
            h ^= this.getArg(i).hashCode();
        }
        return h;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    public boolean adjustRequiredType(JavaExternalObjectType requiredType) throws XPathException {
        return false;
    }

    public static abstract class FunctionCallElaborator
    extends PullElaborator {
        protected SequenceEvaluator[] argumentEvaluators;

        @Override
        public void setExpression(Expression expr) {
            super.setExpression(expr);
            this.allocateArgumentEvaluators((FunctionCall)expr, true);
        }

        protected void allocateArgumentEvaluators(FunctionCall expr, boolean allowRepeatedUse) {
            int arity = expr.getArity();
            this.argumentEvaluators = new SequenceEvaluator[arity];
            for (int i = 0; i < arity; ++i) {
                this.argumentEvaluators[i] = expr.getArg(i).makeElaborator().lazily(allowRepeatedUse);
            }
        }

        protected Sequence[] evaluateArguments(XPathContext context) throws XPathException {
            Sequence[] args = new Sequence[this.argumentEvaluators.length];
            for (int i = 0; i < this.argumentEvaluators.length; ++i) {
                args[i] = this.argumentEvaluators[i].evaluate(context);
            }
            return args;
        }
    }
}

