/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.TimeValue;

public class DateTimeConstructor
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        DateValue arg0 = (DateValue)arguments[0].head();
        TimeValue arg1 = (TimeValue)arguments[1].head();
        if (arg0 == null || arg1 == null) {
            return EmptySequence.getInstance();
        }
        return DateTimeValue.makeDateTimeValue(arg0, arg1);
    }

    @Override
    public String getCompilerName() {
        return "DateTimeConstructorCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new DateTimeFnElaborator();
    }

    public static class DateTimeFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall sfc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator arg0eval = sfc.getArg(0).makeElaborator().elaborateForItem();
            ItemEvaluator arg1eval = sfc.getArg(1).makeElaborator().elaborateForItem();
            return context -> DateTimeValue.makeDateTimeValue((DateValue)arg0eval.eval(context), (TimeValue)arg1eval.eval(context));
        }
    }
}

