/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.functions.RegexFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Matches
extends RegexFunction {
    @Override
    protected boolean allowRegexMatchingEmptyString() {
        return true;
    }

    public boolean evalMatches(AtomicValue input, AtomicValue regex, UnicodeString flags, XPathContext context) throws XPathException {
        RegularExpression re;
        if (regex == null) {
            return false;
        }
        try {
            Object lang = "XP30";
            if (context.getConfiguration().getXsdVersion() == 11) {
                lang = (String)lang + "/XSD11";
            }
            re = context.getConfiguration().compileRegularExpression(regex.getUnicodeStringValue(), flags.toString(), (String)lang, null);
        }
        catch (XPathException err) {
            XPathException de = new XPathException(err);
            de.maybeSetErrorCode("FORX0002");
            de.setXPathContext(context);
            throw de;
        }
        return re.containsMatch(input.getUnicodeStringValue());
    }

    public boolean evalMatches(UnicodeString input, UnicodeString regex, UnicodeString flags, XPathContext context) throws XPathException {
        RegularExpression re;
        if (regex == null) {
            return false;
        }
        try {
            Object lang = "XP30";
            if (context.getConfiguration().getXsdVersion() == 11) {
                lang = (String)lang + "/XSD11";
            }
            re = context.getConfiguration().compileRegularExpression(regex, flags.toString(), (String)lang, null);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("FORX0002");
            err.maybeSetContext(context);
            throw err;
        }
        return re.containsMatch(input);
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        RegularExpression re = this.getRegularExpression(arguments);
        StringValue arg = (StringValue)arguments[0].head();
        UnicodeString in = arg == null ? EmptyUnicodeString.getInstance() : arg.getUnicodeStringValue();
        boolean result = re.containsMatch(in);
        return BooleanValue.get(result);
    }

    @Override
    public String getCompilerName() {
        return "MatchesCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new MatchesFnElaborator();
    }

    public static class MatchesFnElaborator
    extends BooleanElaborator {
        @Override
        public BooleanEvaluator elaborateForBoolean() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Matches fn = (Matches)fnc.getTargetFunction();
            UnicodeStringEvaluator arg0eval = fnc.getArg(0).makeElaborator().elaborateForUnicodeString(true);
            RegularExpression staticRegex = fn.getStaticRegex();
            if (staticRegex == null) {
                UnicodeStringEvaluator arg1eval = fnc.getArg(1).makeElaborator().elaborateForUnicodeString(true);
                UnicodeStringEvaluator arg2eval = fn.getArity() == 3 ? fnc.getArg(2).makeElaborator().elaborateForUnicodeString(true) : cxt -> EmptyUnicodeString.getInstance();
                return context -> {
                    try {
                        return fn.evalMatches(arg0eval.eval(context), arg1eval.eval(context), arg2eval.eval(context), context);
                    }
                    catch (XPathException err) {
                        err.maybeSetLocation(fnc.getLocation());
                        err.maybeSetContext(context);
                        throw err;
                    }
                };
            }
            return context -> staticRegex.containsMatch(arg0eval.eval(context));
        }
    }
}

