/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class QNameFn
extends SystemFunction {
    public static QNameValue expandedQName(StringValue namespace, StringValue lexical) throws XPathException {
        String uri = namespace == null ? null : namespace.getStringValue();
        try {
            String[] parts = NameChecker.getQNameParts(lexical.getStringValue());
            if (!parts[0].isEmpty() && !NameChecker.isValidNCName(parts[0])) {
                XPathException err = new XPathException("Malformed prefix in QName: '" + parts[0] + "'");
                err.setErrorCode("FOCA0002");
                throw err;
            }
            return new QNameValue(parts[0], NamespaceUri.of(uri), parts[1], BuiltInAtomicType.QNAME, true);
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage(), "FOCA0002");
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart().equals("FORG0001")) {
                err.setErrorCode("FOCA0002");
            }
            throw err;
        }
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return QNameFn.expandedQName((StringValue)arguments[0].head(), (StringValue)arguments[1].head());
    }

    @Override
    public String getCompilerName() {
        return "QNameFnCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new QNameFnElaborator();
    }

    public static class QNameFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall sfc = (SystemFunctionCall)this.getExpression();
            if (sfc.getArity() == 2) {
                ItemEvaluator arg0eval = sfc.getArg(0).makeElaborator().elaborateForItem();
                ItemEvaluator arg1eval = sfc.getArg(1).makeElaborator().elaborateForItem();
                return context -> QNameFn.expandedQName((StringValue)arg0eval.eval(context), (StringValue)arg1eval.eval(context));
            }
            ItemEvaluator arg0eval = sfc.getArg(0).makeElaborator().elaborateForItem();
            RetainedStaticContext resolver = sfc.getRetainedStaticContext();
            return context -> {
                Item in = arg0eval.eval(context);
                if (in == null) {
                    return null;
                }
                StructuredQName qn = StructuredQName.fromLexicalQName(in.getStringValue(), false, true, resolver);
                return new QNameValue(qn, BuiltInAtomicType.QNAME);
            };
        }
    }
}

