/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class Root_1
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] arguments) {
        int prop = 25296896;
        if (this.getArity() == 0 || (arguments[0].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node = (NodeInfo)arguments[0].head();
        if (node == null) {
            return EmptySequence.getInstance();
        }
        return node.getRoot();
    }

    @Override
    public String getStreamerName() {
        return "Root";
    }

    @Override
    public String getCompilerName() {
        return "RootFunctionCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new RootFnElaborator();
    }

    public static class RootFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForItem();
            return context -> {
                NodeInfo focus = (NodeInfo)arg0Eval.eval(context);
                return focus == null ? null : focus.getRoot();
            };
        }
    }
}

